/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.MateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class DOCraftingWindow
extends AbstractModuleWindow {
    private static final String RESOURCE_STRING = ":gui/layouthuts/layoutdocrafting.xml";
    private final ScrollingList resourceList;
    public final Container inputInventory = new SimpleContainer(MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount()){};
    private final CraftingModuleView craftingModuleView;

    public DOCraftingWindow(IBuildingView building, CraftingModuleView view) {
        super(building, "minecolonies:gui/layouthuts/layoutdocrafting.xml");
        this.craftingModuleView = view;
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.registerButton("addBlock1", this::addBlock1);
        this.registerButton("addBlock2", this::addBlock2);
        this.registerButton("addBlock3", this::addBlock3);
        this.registerButton("add", this::addRecipe);
    }

    private void addRecipe() {
        List list = Minecraft.m_91087_().f_91073_.m_7465_().m_44056_(com.ldtteam.domumornamentum.recipe.ModRecipeTypes.ARCHITECTS_CUTTER, this.inputInventory, (Level)Minecraft.m_91087_().f_91073_);
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        if (this.inputInventory.m_7983_()) {
            return;
        }
        for (ArchitectsCutterRecipe recipe : list) {
            Block block;
            ItemStack result = recipe.m_5874_(this.inputInventory).m_41777_();
            if (!(result.m_41720_() instanceof BlockItem) || !((block = ((BlockItem)result.m_41720_()).m_40614_()) instanceof IMateriallyTexturedBlock)) continue;
            int components = ((IMateriallyTexturedBlock)block).getComponents().size();
            List inputList = map.getOrDefault(components, new ArrayList());
            inputList.add(list.indexOf(recipe));
            map.put(components, inputList);
        }
        int inputCount = 0;
        for (int i = 0; i < this.inputInventory.m_6643_(); ++i) {
            if (this.inputInventory.m_8020_(i).m_41619_()) continue;
            ++inputCount;
        }
        List inputIndizes = (List)map.get(inputCount);
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        for (int i = 0; i < inputCount; ++i) {
            ItemStack atPos = this.inputInventory.m_8020_(i).m_41777_();
            if (ItemStackUtils.isEmpty(atPos).booleanValue()) continue;
            atPos.m_41764_(1);
            input.add(new ItemStorage(atPos));
        }
        ArrayList<ItemStack> additionalOutput = new ArrayList<ItemStack>();
        for (int i = 1; i < inputIndizes.size(); ++i) {
            additionalOutput.add(((ArchitectsCutterRecipe)list.get((Integer)inputIndizes.get(i))).m_5874_(this.inputInventory).m_41777_());
        }
        IRecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, 3, ((ArchitectsCutterRecipe)list.get((Integer)inputIndizes.get(0))).m_5874_(this.inputInventory).m_41777_(), Blocks.f_50016_, null, ModRecipeTypes.MULTI_OUTPUT_ID, additionalOutput, new ArrayList()});
        Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(this.buildingView, false, storage, this.craftingModuleView.getId()));
    }

    private void addBlock1() {
        new WindowSelectRes(this, this.buildingView, stack -> MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(0, stack), (stack, qty) -> {
            this.inputInventory.m_6836_(0, stack);
            ((ItemIcon)this.findPaneOfTypeByID("block1Icon", ItemIcon.class)).setItem(stack);
            this.updateStockList();
        }, false).open();
    }

    private void addBlock2() {
        new WindowSelectRes(this, this.buildingView, stack -> MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(1, stack), (stack, qty) -> {
            this.inputInventory.m_6836_(1, stack);
            ((ItemIcon)this.findPaneOfTypeByID("block2Icon", ItemIcon.class)).setItem(stack);
            this.updateStockList();
        }, false).open();
    }

    private void addBlock3() {
        new WindowSelectRes(this, this.buildingView, stack -> MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(2, stack), (stack, qty) -> {
            this.inputInventory.m_6836_(2, stack);
            this.updateStockList();
            ((ItemIcon)this.findPaneOfTypeByID("block3Icon", ItemIcon.class)).setItem(stack);
        }, false).open();
    }

    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        List list = Minecraft.m_91087_().f_91073_.m_7465_().m_44056_(com.ldtteam.domumornamentum.recipe.ModRecipeTypes.ARCHITECTS_CUTTER, this.inputInventory, (Level)Minecraft.m_91087_().f_91073_);
        int inputCount = 0;
        for (int i = 0; i < this.inputInventory.m_6643_(); ++i) {
            if (this.inputInventory.m_8020_(i).m_41619_()) continue;
            ++inputCount;
        }
        final ArrayList<ArchitectsCutterRecipe> filteredList = new ArrayList<ArchitectsCutterRecipe>();
        for (ArchitectsCutterRecipe recipe : list) {
            Block block;
            ItemStack result = recipe.m_5874_(this.inputInventory).m_41777_();
            if (!(result.m_41720_() instanceof BlockItem) || !((block = ((BlockItem)result.m_41720_()).m_40614_()) instanceof IMateriallyTexturedBlock) || ((IMateriallyTexturedBlock)block).getComponents().size() != inputCount) continue;
            filteredList.add(recipe);
        }
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return filteredList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ArchitectsCutterRecipe)filteredList.get(index)).m_5874_(DOCraftingWindow.this.inputInventory).m_41777_();
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.m_41786_());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText((MutableComponent)new TextComponent(String.valueOf(resource.m_41613_())));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

