/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallColonyDelete;
import com.minecolonies.coremod.network.messages.client.CreateColonyMessage;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class WindowTownHallColonyManage
extends AbstractWindowSkeleton {
    private static final String BUTTON_CLOSE = "cancel";
    private static final String BUTTON_DELETE = "delete";
    private static final String BUTTON_CREATE = "create";
    private static final String TEXT_NEARBY = "nearbycolony";
    private static final String TEXT_OWN = "owncolony";
    private static final String TEXT_FEEDBACK = "creationpossible";
    private final BlockPos pos;

    public WindowTownHallColonyManage(Player player, BlockPos pos, Level world) {
        super("minecolonies:gui/townhall/windowcolonymanagement.xml");
        this.pos = pos;
        IColony existingColony = IColonyManager.getInstance().getIColony(world, pos);
        if (existingColony != null) {
            ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.here", new Object[]{existingColony.getName(), existingColony.getPermissions().getOwnerName()}));
        } else {
            int closeClonyID = WindowTownHallColonyManage.findNextNearbyColony(world, pos, (Integer)MineColonies.getConfig().getServer().minColonyDistance.get());
            if (closeClonyID != 0) {
                ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.near", new Object[]{closeClonyID}));
            } else {
                ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.nonenearby"));
            }
        }
        IColony ownerColony = IColonyManager.getInstance().getIColonyByOwner(world, player);
        if (ownerColony != null) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_DELETE, ButtonImage.class)).enable();
            ((Text)this.findPaneOfTypeByID(TEXT_OWN, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.own", new Object[]{ownerColony.getCenter()}));
            if (((Boolean)MineColonies.getConfig().getServer().allowInfiniteColonies.get()).booleanValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.denied.existingandabandon"));
            } else {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.denied.existing"));
            }
        } else {
            IColony colony;
            ((Text)this.findPaneOfTypeByID(TEXT_OWN, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.none"));
            if (!(existingColony == null && IColonyManager.getInstance().isFarEnoughFromColonies(world, pos) || (colony = existingColony != null ? existingColony : IColonyManager.getInstance().getClosestColony(world, pos)) == null)) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText(LanguageHandler.buildChatComponent((String)"com.minecolonies.coremod.gui.colony.denied.tooclose", (Object[])new Object[]{colony.getName()}));
            }
        }
        if (((Boolean)MineColonies.getConfig().getServer().restrictColonyPlacement.get()).booleanValue()) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(pos, new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_())));
            if (spawnDistance < (double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.tooclose", new Object[]{MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()}));
            } else if (spawnDistance > (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.toofar", new Object[]{MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()}));
            }
        }
        if (((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).isTextEmpty()) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CREATE, ButtonImage.class)).enable();
            ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.colony.allowed.create"));
        }
        this.registerButton(BUTTON_CLOSE, () -> this.close());
        this.registerButton(BUTTON_CREATE, () -> this.onCreate());
        this.registerButton(BUTTON_DELETE, () -> new WindowTownHallColonyDelete().open());
    }

    public void onCreate() {
        new VanillaParticleMessage(this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), ParticleTypes.f_123799_).onExecute(null, false);
        Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, new BlockPos(Minecraft.m_91087_().f_91074_.m_20182_()), SoundEvents.f_11784_, SoundSource.AMBIENT, 2.5f, 0.8f);
        boolean reactivate = false;
        BlockEntity entity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
        if (entity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding hut = (TileEntityColonyBuilding)entity;
            reactivate = hut.getPositionedTags().containsKey(BlockPos.f_121853_) && hut.getPositionedTags().get(BlockPos.f_121853_).contains("deactivated");
        }
        Network.getNetwork().sendToServer(new CreateColonyMessage(this.pos, reactivate));
        this.close();
    }

    private static int findNextNearbyColony(Level world, BlockPos start, int range) {
        int startX = start.m_123341_() >> 4;
        int startZ = start.m_123343_() >> 4;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                int chunkX = startX + x;
                int chunkZ = startZ + z;
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (cap == null) continue;
                if (cap.getOwningColony() != 0) {
                    return cap.getOwningColony();
                }
                if (cap.getAllCloseColonies().isEmpty()) continue;
                return cap.getAllCloseColonies().get(0);
            }
        }
        return 0;
    }
}

