/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.ldtteam.blockui.MatrixUtils;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.minecolonies.coremod.util.MutableChunkPos;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class ColonyBorderRenderer {
    private static final int RENDER_DIST_THRESHOLD = 3;
    private static final int CHUNK_SIZE = 16;
    private static final int CHUNK_HEIGHT = 256;
    private static final int PLAYER_CHUNK_STEP = 4;
    private static Pair<BufferBuilder.DrawState, ByteBuffer> colonies = null;
    private static Pair<BufferBuilder.DrawState, ByteBuffer> chunktickets = null;
    private static ChunkPos lastPlayerChunkPos = null;
    private static IColonyView lastColony = null;

    static void render(WorldEventContext ctx) {
        if (ctx.mainHandItem.m_41720_() != ModItems.buildTool.get() || !ctx.hasNearestColony()) {
            return;
        }
        ChunkPos playerChunkPos = new ChunkPos(ctx.clientPlayer.m_142538_());
        if (lastColony != ctx.nearestColony || !lastPlayerChunkPos.equals((Object)playerChunkPos)) {
            lastColony = ctx.nearestColony;
            lastPlayerChunkPos = playerChunkPos;
            HashMap<ChunkPos, Integer> coloniesMap = new HashMap<ChunkPos, Integer>();
            HashMap<ChunkPos, Integer> chunkticketsMap = new HashMap<ChunkPos, Integer>();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            int nearestColonyId = ctx.nearestColony.getID();
            int playerRenderDist = Math.max(ctx.clientRenderDist - 3, 2);
            int range = Math.max(ctx.clientRenderDist, (Integer)MineColonies.getConfig().getServer().maxColonySize.get());
            for (int chunkX = -range; chunkX <= range; ++chunkX) {
                for (int chunkZ = -range; chunkZ <= range; ++chunkZ) {
                    LevelChunk chunk = ctx.clientLevel.m_6325_(playerChunkPos.f_45578_ + chunkX, playerChunkPos.f_45579_ + chunkZ);
                    ChunkPos chunkPos = chunk.m_7697_();
                    chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).ifPresent(cap -> coloniesMap.put(chunkPos, cap.getOwningColony()));
                    if (ctx.nearestColony.getTicketedChunks().contains(chunkPos.m_45588_())) {
                        chunkticketsMap.put(chunkPos, nearestColonyId);
                        continue;
                    }
                    chunkticketsMap.put(chunkPos, 0);
                }
            }
            colonies = ColonyBorderRenderer.draw(bufferbuilder, coloniesMap, nearestColonyId, playerChunkPos, playerRenderDist);
            chunktickets = ColonyBorderRenderer.draw(bufferbuilder, chunkticketsMap, nearestColonyId, playerChunkPos, playerRenderDist);
            bufferbuilder.m_141991_();
        }
        Pair<BufferBuilder.DrawState, ByteBuffer> p = Screen.m_96637_() ? chunktickets : colonies;
        BufferBuilder.DrawState ds = (BufferBuilder.DrawState)p.getFirst();
        MatrixUtils.pushShaderMVstack((PoseStack)ctx.poseStack);
        WorldRenderMacros.LINES.m_110185_();
        BufferUploader.m_166838_((ByteBuffer)((ByteBuffer)p.getSecond()), (VertexFormat.Mode)ds.m_166810_(), (VertexFormat)ds.m_85745_(), (int)ds.m_85746_(), (VertexFormat.IndexType)ds.m_166811_(), (int)ds.m_166809_(), (boolean)ds.m_166815_());
        WorldRenderMacros.LINES.m_110188_();
        MatrixUtils.popShaderMVstack();
    }

    private static Pair<BufferBuilder.DrawState, ByteBuffer> draw(BufferBuilder bufferbuilder, Map<ChunkPos, Integer> mapToDraw, int playerColonyId, ChunkPos playerChunkPos, int playerRenderDist) {
        MutableChunkPos mutableChunkPos = new MutableChunkPos(0, 0);
        HashMap colonyColours = new HashMap();
        boolean useColonyColour = (Boolean)IMinecoloniesAPI.getInstance().getConfig().getClient().colonyteamborders.get();
        bufferbuilder.m_166779_(WorldRenderMacros.LINES.m_173186_(), WorldRenderMacros.LINES.m_110508_());
        mapToDraw.forEach((chunkPos, colonyId) -> {
            block32: {
                int y;
                int shift;
                boolean west;
                if (colonyId == 0 || chunkPos.f_45578_ <= playerChunkPos.f_45578_ - playerRenderDist || chunkPos.f_45578_ >= playerChunkPos.f_45578_ + playerRenderDist || chunkPos.f_45579_ <= playerChunkPos.f_45579_ - playerRenderDist || chunkPos.f_45579_ >= playerChunkPos.f_45579_ + playerRenderDist) {
                    return;
                }
                boolean isPlayerChunkX = colonyId == playerColonyId && chunkPos.f_45578_ == playerChunkPos.f_45578_;
                boolean isPlayerChunkZ = colonyId == playerColonyId && chunkPos.f_45579_ == playerChunkPos.f_45579_;
                float minX = chunkPos.m_45604_();
                float maxX = (float)chunkPos.m_45608_() + 1.0f;
                float minZ = chunkPos.m_45605_();
                float maxZ = (float)chunkPos.m_45609_() + 1.0f;
                int testedColonyId = colonyId;
                if (useColonyColour) {
                    Color colour = colonyColours.computeIfAbsent(colonyId, id -> {
                        IColonyView colony = IMinecoloniesAPI.getInstance().getColonyManager().getColonyView((int)id, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
                        ChatFormatting team = colony != null ? colony.getTeamColonyColor() : (id == playerColonyId ? ChatFormatting.WHITE : ChatFormatting.RED);
                        return new Color(team.m_126665_());
                    });
                    bufferbuilder.m_142461_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getAlpha());
                } else if (colonyId == playerColonyId) {
                    bufferbuilder.m_142461_(255, 255, 255, 255);
                } else {
                    bufferbuilder.m_142461_(255, 70, 70, 255);
                }
                mutableChunkPos.setX(chunkPos.f_45578_);
                mutableChunkPos.setZ(chunkPos.f_45579_ - 1);
                boolean north = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                mutableChunkPos.setZ(chunkPos.f_45579_ + 1);
                boolean south = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                mutableChunkPos.setX(chunkPos.f_45578_ + 1);
                mutableChunkPos.setZ(chunkPos.f_45579_);
                boolean east = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                mutableChunkPos.setX(chunkPos.f_45578_ - 1);
                boolean bl = west = mapToDraw.getOrDefault((Object)mutableChunkPos, -1) != testedColonyId;
                if (north || west) {
                    bufferbuilder.m_5483_((double)minX, 0.0, (double)minZ).m_5752_();
                    bufferbuilder.m_5483_((double)minX, 256.0, (double)minZ).m_5752_();
                }
                if (north || east) {
                    bufferbuilder.m_5483_((double)maxX, 0.0, (double)minZ).m_5752_();
                    bufferbuilder.m_5483_((double)maxX, 256.0, (double)minZ).m_5752_();
                }
                if (south || west) {
                    bufferbuilder.m_5483_((double)minX, 0.0, (double)maxZ).m_5752_();
                    bufferbuilder.m_5483_((double)minX, 256.0, (double)maxZ).m_5752_();
                }
                if (south || east) {
                    bufferbuilder.m_5483_((double)maxX, 0.0, (double)maxZ).m_5752_();
                    bufferbuilder.m_5483_((double)maxX, 256.0, (double)maxZ).m_5752_();
                }
                if (north) {
                    if (isPlayerChunkX) {
                        for (shift = 4; shift < 16; shift += 4) {
                            bufferbuilder.m_5483_((double)(minX + (float)shift), 0.0, (double)minZ).m_5752_();
                            bufferbuilder.m_5483_((double)(minX + (float)shift), 256.0, (double)minZ).m_5752_();
                        }
                        for (y = 4; y < 256; y += 4) {
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)minZ).m_5752_();
                            bufferbuilder.m_5483_((double)maxX, (double)y, (double)minZ).m_5752_();
                        }
                    } else {
                        for (y = 16; y < 256; y += 16) {
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)minZ).m_5752_();
                            bufferbuilder.m_5483_((double)maxX, (double)y, (double)minZ).m_5752_();
                        }
                    }
                }
                if (south) {
                    if (isPlayerChunkX) {
                        for (shift = 4; shift < 16; shift += 4) {
                            bufferbuilder.m_5483_((double)(minX + (float)shift), 0.0, (double)maxZ).m_5752_();
                            bufferbuilder.m_5483_((double)(minX + (float)shift), 256.0, (double)maxZ).m_5752_();
                        }
                        for (y = 4; y < 256; y += 4) {
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)maxZ).m_5752_();
                            bufferbuilder.m_5483_((double)maxX, (double)y, (double)maxZ).m_5752_();
                        }
                    } else {
                        for (y = 16; y < 256; y += 16) {
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)maxZ).m_5752_();
                            bufferbuilder.m_5483_((double)maxX, (double)y, (double)maxZ).m_5752_();
                        }
                    }
                }
                if (west) {
                    if (isPlayerChunkZ) {
                        for (shift = 4; shift < 16; shift += 4) {
                            bufferbuilder.m_5483_((double)minX, 0.0, (double)(minZ + (float)shift)).m_5752_();
                            bufferbuilder.m_5483_((double)minX, 256.0, (double)(minZ + (float)shift)).m_5752_();
                        }
                        for (y = 4; y < 256; y += 4) {
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)minZ).m_5752_();
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)maxZ).m_5752_();
                        }
                    } else {
                        for (y = 16; y < 256; y += 16) {
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)minZ).m_5752_();
                            bufferbuilder.m_5483_((double)minX, (double)y, (double)maxZ).m_5752_();
                        }
                    }
                }
                if (!east) break block32;
                if (isPlayerChunkZ) {
                    for (shift = 4; shift < 16; shift += 4) {
                        bufferbuilder.m_5483_((double)maxX, 0.0, (double)(minZ + (float)shift)).m_5752_();
                        bufferbuilder.m_5483_((double)maxX, 256.0, (double)(minZ + (float)shift)).m_5752_();
                    }
                    for (y = 4; y < 256; y += 4) {
                        bufferbuilder.m_5483_((double)maxX, (double)y, (double)minZ).m_5752_();
                        bufferbuilder.m_5483_((double)maxX, (double)y, (double)maxZ).m_5752_();
                    }
                } else {
                    for (y = 16; y < 256; y += 16) {
                        bufferbuilder.m_5483_((double)maxX, (double)y, (double)minZ).m_5752_();
                        bufferbuilder.m_5483_((double)maxX, (double)y, (double)maxZ).m_5752_();
                    }
                }
            }
        });
        bufferbuilder.m_85721_();
        Pair preResult = bufferbuilder.m_85728_();
        ByteBuffer temp = MemoryTracker.m_182527_((int)((ByteBuffer)preResult.getSecond()).capacity());
        ((ByteBuffer)preResult.getSecond()).clear();
        temp.clear();
        temp.order(((ByteBuffer)preResult.getSecond()).order());
        temp.put((ByteBuffer)preResult.getSecond());
        return Pair.of((Object)((BufferBuilder.DrawState)preResult.getFirst()), (Object)temp);
    }
}

