/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AnimalHerdingModule
extends AbstractBuildingModule {
    private final JobEntry jobEntry;
    private final EntityType<?> animalType;
    private final ItemStack breedingItem;

    public AnimalHerdingModule(@NotNull JobEntry jobEntry, @NotNull EntityType<?> animalType, @NotNull ItemStack breedingItem) {
        this.jobEntry = jobEntry;
        this.animalType = animalType;
        this.breedingItem = breedingItem;
    }

    @NotNull
    public IJob<?> getHerdingJob() {
        return this.jobEntry.produceJob(null);
    }

    @NotNull
    public EntityType<?> getAnimalType() {
        return this.animalType;
    }

    @NotNull
    public List<ItemStack> getBreedingItems() {
        return Collections.singletonList(this.breedingItem);
    }

    @NotNull
    public ResourceLocation getDefaultLootTable() {
        return this.getAnimalType().m_20677_();
    }

    @NotNull
    public List<LootTableAnalyzer.LootDrop> getExpectedLoot() {
        return CustomRecipeManager.getInstance().getLootDrops(this.getDefaultLootTable());
    }
}

