/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class CourierAssignmentModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule {
    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (!(data.getJob() instanceof JobDeliveryman) || this.hasAssignedCitizen(data) || ((JobDeliveryman)data.getJob()).findWareHouse() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.getAssignedCitizen())) {
            if (citizenData.getJob() instanceof JobDeliveryman) continue;
            this.removeCitizen(citizenData);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        int[] residentIds;
        super.deserializeNBT(compound);
        CompoundTag jobCompound = compound.m_128469_(this.getModuleSerializationIdentifier());
        for (int citizenId : residentIds = jobCompound.m_128465_("couriers")) {
            ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
            if (citizen == null) continue;
            this.assignCitizen(citizen);
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        CompoundTag jobCompound;
        super.serializeNBT(compound);
        CompoundTag compoundTag = jobCompound = compound.m_128441_(this.getModuleSerializationIdentifier()) ? compound.m_128469_(this.getModuleSerializationIdentifier()) : new CompoundTag();
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            jobCompound.m_128385_("couriers", residentIds);
        }
        compound.m_128365_(this.getModuleSerializationIdentifier(), (Tag)jobCompound);
    }

    @Override
    public void onRemoval(ICitizenData citizen) {
    }

    @Override
    public void onAssignment(ICitizenData citizen) {
    }

    @Override
    public int getModuleMax() {
        return this.building.getBuildingLevel() * 2;
    }

    @Override
    public JobEntry getJobEntry() {
        return ModJobs.delivery;
    }

    @Override
    protected String getModuleSerializationIdentifier() {
        return "warehouse";
    }
}

