/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorkerModule;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class WorkerBuildingModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule,
IBuildingWorkerModule,
ICreatesResolversModule {
    private final Skill primary;
    private final Skill secondary;
    private final JobEntry jobEntry;
    private final boolean canWorkingDuringRain;
    private final Function<IBuilding, Integer> sizeLimit;

    public WorkerBuildingModule(JobEntry entry, Skill primary, Skill secondary, boolean canWorkingDuringRain, Function<IBuilding, Integer> sizeLimit) {
        this.jobEntry = entry;
        this.primary = primary;
        this.secondary = secondary;
        this.canWorkingDuringRain = canWorkingDuringRain;
        this.sizeLimit = sizeLimit;
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            for (WorkerBuildingModule module : citizen.getWorkBuilding().getModules(WorkerBuildingModule.class)) {
                if (!module.hasAssignedCitizen(citizen)) continue;
                module.removeCitizen(citizen);
            }
        }
        if (!super.assignCitizen(citizen)) {
            Log.getLogger().warn("Unable to assign citizen:" + citizen.getName() + " to building:" + this.building.getSchematicName() + " jobname:" + this.getJobDisplayName());
            return false;
        }
        return true;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        block3: {
            int[] residentIds;
            block2: {
                super.deserializeNBT(compound);
                if (!compound.m_128431_().contains("worker")) break block2;
                ListTag workersTagList = compound.m_128437_("worker", 10);
                for (int i = 0; i < workersTagList.size(); ++i) {
                    ICitizenData data = this.building.getColony().getCitizenManager().getCivilian(workersTagList.m_128728_(i).m_128451_("workerId"));
                    if (data == null || data.getJob() == null || data.getJob().getJobRegistryEntry() != this.jobEntry) continue;
                    this.assignCitizen(data);
                }
                break block3;
            }
            if (!compound.m_128441_(this.jobEntry.getKey().toString())) break block3;
            CompoundTag jobCompound = compound.m_128469_(this.jobEntry.getKey().toString());
            for (int citizenId : residentIds = jobCompound.m_128465_("residents")) {
                ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        ICitizenData joblessCitizen;
        if (!this.isFull() && (this.building.getBuildingLevel() > 0 && this.building.isBuilt() || this.building instanceof BuildingBuilder) && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO) && (joblessCitizen = colony.getCitizenManager().getJoblessCitizen()) != null) {
            this.assignCitizen(joblessCitizen);
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        CompoundTag jobCompound;
        super.serializeNBT(compound);
        CompoundTag compoundTag = jobCompound = compound.m_128441_(this.getModuleSerializationIdentifier()) ? compound.m_128469_(this.getModuleSerializationIdentifier()) : new CompoundTag();
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            jobCompound.m_128385_("residents", residentIds);
        }
        compound.m_128365_(this.getModuleSerializationIdentifier(), (Tag)jobCompound);
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeRegistryId((IForgeRegistryEntry)this.jobEntry);
        buf.writeInt(this.getPrimarySkill().ordinal());
        buf.writeInt(this.getSecondarySkill().ordinal());
    }

    @Override
    void onAssignment(ICitizenData citizen) {
        citizen.setWorkBuilding(this.building);
        for (AbstractCraftingBuildingModule module : this.building.getModules(AbstractCraftingBuildingModule.class)) {
            module.updateWorkerAvailableForRecipes();
        }
        citizen.getJob().onLevelUp();
        this.building.getColony().getProgressManager().progressEmploy((int)this.building.getColony().getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getJob() != null).count());
    }

    @Override
    void onRemoval(ICitizenData citizen) {
        citizen.setWorkBuilding(null);
        this.building.cancelAllRequestsOfCitizen(citizen);
        citizen.setVisibleStatus(null);
    }

    @Override
    public int getModuleMax() {
        return this.sizeLimit.apply(this.building);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        for (Optional<AbstractEntityCitizen> entityCitizen : Objects.requireNonNull(this.getAssignedEntities())) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    public String getJobDisplayName() {
        return new TranslatableComponent(this.jobEntry.getTranslationKey()).getString();
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return this.jobEntry.produceJob(citizen);
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return this.building.getBuildingLevel() >= this.building.getMaxBuildingLevel() || this.canWorkingDuringRain;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return this.primary;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return this.secondary;
    }

    @Override
    public List<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new IRequestResolver[]{new BuildingRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new PrivateWorkerCraftingRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry), new PrivateWorkerCraftingProductionResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry)});
        return builder.build();
    }

    @Override
    public JobEntry getJobEntry() {
        return this.jobEntry;
    }

    @Override
    protected String getModuleSerializationIdentifier() {
        return this.jobEntry.getKey().toString();
    }
}

