/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.settings.PatrolModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSettingWithDesc;
import com.minecolonies.coremod.colony.buildings.moduleviews.ToolModuleView;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuardTaskSetting
extends StringSettingWithDesc {
    public static final String PATROL = "com.minecolonies.core.guard.setting.patrol";
    public static final String GUARD = "com.minecolonies.core.guard.setting.guard";
    public static final String FOLLOW = "com.minecolonies.core.guard.setting.follow";
    public static final String PATROL_MINE = "com.minecolonies.core.guard.setting.patrol_mine";

    public GuardTaskSetting() {
        super(PATROL, GUARD, FOLLOW, PATROL_MINE);
    }

    public GuardTaskSetting(String ... list) {
        super(list);
    }

    public GuardTaskSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        Loader.createFromXMLFile((ResourceLocation)new ResourceLocation("minecolonies:gui/layouthuts/layoutguardtasksetting.xml"), (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.setting." + key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        String setting = this.getSettings().get(this.getCurrentIndex());
        ButtonImage targetButton = (ButtonImage)pane.findPaneOfTypeByID("setTarget", ButtonImage.class);
        Text mineLabel = (Text)pane.findPaneOfTypeByID("minePos", Text.class);
        if (setting.equals(PATROL_MINE) && building instanceof AbstractBuildingGuards.View) {
            mineLabel.setVisible(true);
            if (((AbstractBuildingGuards.View)building).getMinePos() != null) {
                mineLabel.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.worherhuts.patrollingmine", new Object[]{((AbstractBuildingGuards.View)building).getMinePos().m_123344_()}));
            } else {
                mineLabel.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.job.guard.assignmine"));
            }
            targetButton.setVisible(false);
        } else if (!setting.equals(FOLLOW)) {
            mineLabel.setVisible(false);
            targetButton.setVisible(true);
            if (setting.equals(PATROL)) {
                if (!settingsModuleView.getSetting(AbstractBuildingGuards.PATROL_MODE).getValue().equals(PatrolModeSetting.MANUAL)) {
                    targetButton.setVisible(false);
                } else {
                    targetButton.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.targetpatrol"));
                }
            } else {
                targetButton.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.targetguard"));
            }
            targetButton.setHandler(button -> building.getModuleView(ToolModuleView.class).getWindow().open());
        } else {
            mineLabel.setVisible(false);
            targetButton.setVisible(false);
        }
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((MutableComponent)new TranslatableComponent(setting));
    }

    @Override
    public void onUpdate(IBuilding building, ServerPlayer sender) {
        if (building instanceof AbstractBuildingGuards && this.getValue().equals(FOLLOW)) {
            ((AbstractBuildingGuards)building).setPlayerToFollow((Player)sender);
        }
    }
}

