/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.FarmerFieldsModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignmentModeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class FarmerFieldModuleView
extends AbstractBuildingModuleView {
    private boolean shouldAssignFieldManually;
    @NotNull
    private List<BlockPos> fields = new ArrayList<BlockPos>();
    private int amountOfFields;

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.farmerhut.fields";
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.fields = new ArrayList<BlockPos>();
        this.shouldAssignFieldManually = buf.readBoolean();
        int size = buf.readInt();
        for (int i = 1; i <= size; ++i) {
            @NotNull BlockPos pos = buf.m_130135_();
            this.fields.add(pos);
        }
        this.amountOfFields = buf.readInt();
    }

    public boolean assignFieldManually() {
        return this.shouldAssignFieldManually;
    }

    @NotNull
    public List<BlockPos> getFields() {
        return this.fields;
    }

    public int getAmountOfFields() {
        return this.amountOfFields;
    }

    public void setAssignFieldManually(boolean assignFieldManually) {
        Network.getNetwork().sendToServer(new AssignmentModeMessage(this.buildingView, assignFieldManually));
        this.shouldAssignFieldManually = assignFieldManually;
    }

    public void changeFields(BlockPos id, boolean addNewField, ScarecrowTileEntity scarecrowTileEntity) {
        if (!(this.buildingView == null || addNewField && this.amountOfFields >= this.buildingView.getBuildingLevel())) {
            Network.getNetwork().sendToServer(new AssignFieldMessage(this.buildingView, addNewField, id));
            scarecrowTileEntity.setTaken(addNewField);
            WorkerBuildingModuleView view = this.buildingView.getModuleViewMatching(WorkerBuildingModuleView.class, m -> m.getJobEntry() == ModJobs.farmer);
            if (addNewField) {
                if (!view.getAssignedCitizens().isEmpty()) {
                    scarecrowTileEntity.setOwner(view.getAssignedCitizens().get(0), this.getColony());
                }
                ++this.amountOfFields;
            } else {
                scarecrowTileEntity.setOwner(0, this.getColony());
                --this.amountOfFields;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new FarmerFieldsModuleWindow(this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "field";
    }
}

