/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRecipe {
    public static final String RECIPE_TYPE_PROP = "type";
    public static final String RECIPE_TYPE_RECIPE = "recipe";
    public static final String RECIPE_TYPE_RECIPE_MULT_OUT = "recipe-multi-out";
    public static final String RECIPE_TYPE_RECIPE_MULT_IN = "recipe-multi-in";
    public static final String RECIPE_TYPE_REMOVE = "remove";
    public static final String RECIPE_ID_TO_REMOVE_PROP = "recipe-id-to-remove";
    public static final String RECIPE_CRAFTER_PROP = "crafter";
    public static final String RECIPE_INPUTS_PROP = "inputs";
    public static final String RECIPE_SECONDARY_PROP = "additional-output";
    public static final String RECIPE_ALTERNATE_PROP = "alternate-output";
    public static final String RECIPE_RESULT_PROP = "result";
    public static final String RECIPE_LOOTTABLE_PROP = "loot-table";
    public static final String RECIPE_INTERMEDIATE_PROP = "intermediate";
    public static final String RECIPE_RESEARCHID_PROP = "research-id";
    public static final String RECIPE_EXCLUDED_RESEARCHID_PROP = "not-research-id";
    public static final String RECIPE_BUILDING_MIN_LEVEL_PROP = "min-building-level";
    public static final String RECIPE_BUILDING_MAX_LEVEL_PROP = "max-building-level";
    public static final String RECIPE_MUST_EXIST = "must-exist";
    public static final String RECIPE_SHOW_TOOLTIP = "show-tooltip";
    private String crafter = "unknown";
    private ResourceLocation recipeId = null;
    private List<ItemStorage> inputs = new ArrayList<ItemStorage>();
    private List<ItemStack> altOutputs = new ArrayList<ItemStack>();
    private ItemStack result = null;
    private List<ItemStack> secondary = new ArrayList<ItemStack>();
    private Block intermediate = Blocks.f_50016_;
    private ResourceLocation researchId = null;
    private ResourceLocation excludedResearchId = null;
    private int minBldgLevel = 0;
    private int maxBldgLevel = 5;
    private boolean mustExist = false;
    private boolean showTooltip = false;
    private ResourceLocation lootTable;
    private RecipeStorage cachedRecipeStorage;

    private CustomRecipe() {
    }

    public static CustomRecipe parse(@NotNull ResourceLocation recipeId, @NotNull JsonObject recipeJson) {
        ItemStack stack;
        JsonObject ingredient;
        CustomRecipe recipe = new CustomRecipe();
        recipe.recipeId = recipeId;
        if (recipeJson.has(RECIPE_CRAFTER_PROP)) {
            recipe.crafter = recipeJson.get(RECIPE_CRAFTER_PROP).getAsString();
        }
        if (recipeJson.has(RECIPE_INPUTS_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_INPUTS_PROP).getAsJsonArray()) {
                ItemStorage parsed;
                if (!e.isJsonObject() || (parsed = new ItemStorage(ingredient = e.getAsJsonObject())).isEmpty()) continue;
                recipe.inputs.add(parsed);
            }
        }
        recipe.result = recipeJson.has(RECIPE_RESULT_PROP) ? ItemStackUtils.idToItemStack(recipeJson.get(RECIPE_RESULT_PROP).getAsString()) : ItemStack.f_41583_;
        if (recipeJson.has(RECIPE_LOOTTABLE_PROP)) {
            recipe.lootTable = new ResourceLocation(recipeJson.get(RECIPE_LOOTTABLE_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_SECONDARY_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_SECONDARY_PROP).getAsJsonArray()) {
                if (!e.isJsonObject() || !(ingredient = e.getAsJsonObject()).has("item")) continue;
                stack = ItemStackUtils.idToItemStack(ingredient.get("item").getAsString());
                if (ingredient.has("count")) {
                    stack.m_41764_(ingredient.get("count").getAsInt());
                }
                recipe.secondary.add(stack);
            }
        }
        if (recipeJson.has(RECIPE_ALTERNATE_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_ALTERNATE_PROP).getAsJsonArray()) {
                if (!e.isJsonObject() || !(ingredient = e.getAsJsonObject()).has("item")) continue;
                stack = ItemStackUtils.idToItemStack(ingredient.get("item").getAsString());
                if (ingredient.has("count")) {
                    stack.m_41764_(ingredient.get("count").getAsInt());
                }
                recipe.altOutputs.add(stack);
            }
        }
        if (recipeJson.has("count") && !ItemStackUtils.isEmpty(recipe.result).booleanValue()) {
            recipe.result.m_41764_(recipeJson.get("count").getAsInt());
        }
        recipe.intermediate = recipeJson.has(RECIPE_INTERMEDIATE_PROP) ? (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(recipeJson.get(RECIPE_INTERMEDIATE_PROP).getAsString())) : Blocks.f_50016_;
        if (recipeJson.has(RECIPE_RESEARCHID_PROP)) {
            recipe.researchId = new ResourceLocation(recipeJson.get(RECIPE_RESEARCHID_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_EXCLUDED_RESEARCHID_PROP)) {
            recipe.excludedResearchId = new ResourceLocation(recipeJson.get(RECIPE_EXCLUDED_RESEARCHID_PROP).getAsString());
        }
        if (recipeJson.has(RECIPE_BUILDING_MIN_LEVEL_PROP)) {
            recipe.minBldgLevel = recipeJson.get(RECIPE_BUILDING_MIN_LEVEL_PROP).getAsInt();
        }
        if (recipeJson.has(RECIPE_BUILDING_MAX_LEVEL_PROP)) {
            recipe.maxBldgLevel = recipeJson.get(RECIPE_BUILDING_MAX_LEVEL_PROP).getAsInt();
        }
        if (recipeJson.has(RECIPE_MUST_EXIST)) {
            recipe.mustExist = recipeJson.get(RECIPE_MUST_EXIST).getAsBoolean();
        }
        if (recipeJson.has(RECIPE_SHOW_TOOLTIP)) {
            recipe.showTooltip = recipeJson.get(RECIPE_SHOW_TOOLTIP).getAsBoolean();
        }
        return recipe;
    }

    public CustomRecipe(String crafter, int minBldgLevel, int maxBldgLevel, boolean mustExist, boolean showTooltip, ResourceLocation recipeId, @Nullable ResourceLocation researchReq, @Nullable ResourceLocation researchExclude, @Nullable ResourceLocation lootTable, List<ItemStorage> inputs, ItemStack primaryOutput, List<ItemStack> secondaryOutput, List<ItemStack> altOutputs, Block intermediate) {
        this.crafter = crafter;
        this.recipeId = recipeId;
        this.researchId = researchReq;
        this.excludedResearchId = researchExclude;
        this.minBldgLevel = minBldgLevel;
        this.maxBldgLevel = maxBldgLevel;
        this.mustExist = mustExist;
        this.showTooltip = showTooltip;
        this.inputs = inputs;
        this.result = primaryOutput;
        this.secondary = secondaryOutput;
        this.altOutputs = altOutputs;
        this.lootTable = lootTable;
        this.intermediate = intermediate;
    }

    public String getCrafter() {
        return this.crafter;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public List<ItemStorage> getInputs() {
        return this.inputs;
    }

    public ItemStack getPrimaryOutput() {
        return this.result;
    }

    public List<ItemStack> getSecondaryOutput() {
        return this.secondary;
    }

    public List<ItemStack> getAltOutputs() {
        return this.altOutputs;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public ResourceLocation getRequiredResearchId() {
        return this.researchId;
    }

    public ResourceLocation getExcludedResearchId() {
        return this.excludedResearchId;
    }

    public int getMinBuildingLevel() {
        return this.minBldgLevel;
    }

    public int getMaxBuildingLevel() {
        return this.maxBldgLevel;
    }

    public boolean isValidForBuilding(IBuilding building) {
        IColony colony = building.getColony();
        boolean requiredEffectPresent = this.researchId != null ? this.isUnlockEffectResearched(this.researchId, colony) : false;
        boolean excludedEffectPresent = this.excludedResearchId != null ? this.isUnlockEffectResearched(this.excludedResearchId, colony) : false;
        if (this.isPrecursorRecipeMissing(building)) {
            return false;
        }
        int bldgLevel = building.getBuildingLevel();
        return !(this.researchId != null && !requiredEffectPresent || this.excludedResearchId != null && excludedEffectPresent || bldgLevel < this.minBldgLevel || bldgLevel > this.maxBldgLevel);
    }

    private boolean isUnlockEffectResearched(ResourceLocation researchId, IColony colony) {
        if (!IGlobalResearchTree.getInstance().hasResearchEffect(researchId) && !IGlobalResearchTree.getInstance().hasResearch(researchId)) {
            return false;
        }
        if (IGlobalResearchTree.getInstance().hasResearchEffect(researchId) && colony.getResearchManager().getResearchEffects().getEffectStrength(researchId) > 0.0) {
            return true;
        }
        return IGlobalResearchTree.getInstance().hasResearch(researchId) && colony.getResearchManager().getResearchTree().hasCompletedResearch(researchId);
    }

    private boolean isPrecursorRecipeMissing(IBuilding building) {
        if (this.mustExist) {
            IRecipeStorage compareStorage = this.getRecipeStorage();
            ResourceLocation recipeSource = this.getRecipeId();
            for (ICraftingBuildingModule module : building.getModules(ICraftingBuildingModule.class)) {
                for (IToken<?> recipeToken : module.getRecipes()) {
                    IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(recipeToken);
                    if ((storage.getRecipeSource() == null || !storage.getRecipeSource().equals((Object)recipeSource)) && (!ItemStackUtils.compareItemStacksIgnoreStackSize(storage.getPrimaryOutput(), compareStorage.getPrimaryOutput(), false, true) || !storage.getCleanedInput().containsAll(compareStorage.getCleanedInput()) || !compareStorage.getCleanedInput().containsAll(storage.getCleanedInput()))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public IRecipeStorage getRecipeStorage() {
        if (this.cachedRecipeStorage == null) {
            this.cachedRecipeStorage = this.altOutputs.isEmpty() ? StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{this.inputs, 1, this.result, this.intermediate, this.getRecipeId(), ModRecipeTypes.CLASSIC_ID, null, this.secondary, this.lootTable}) : StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{this.inputs, 1, this.result, this.intermediate, this.getRecipeId(), ModRecipeTypes.MULTI_OUTPUT_ID, this.altOutputs, this.secondary, this.lootTable});
            IRecipeManager recipeManager = IColonyManager.getInstance().getRecipeManager();
            IToken<?> cachedRecipeToken = recipeManager.getRecipeId(this.cachedRecipeStorage);
            if (cachedRecipeToken != null && !cachedRecipeToken.equals(this.cachedRecipeStorage.getToken())) {
                this.cachedRecipeStorage = (RecipeStorage)recipeManager.getRecipes().get(cachedRecipeToken);
            }
            recipeManager.registerUse(this.cachedRecipeStorage.getToken());
        }
        return this.cachedRecipeStorage;
    }

    public int hashCode() {
        return Objects.hash(this.result, this.researchId, this.excludedResearchId, this.lootTable, this.inputs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRecipe that = (CustomRecipe)o;
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.result, that.result) != false && Objects.equals(this.researchId, that.researchId) && Objects.equals(this.excludedResearchId, that.excludedResearchId) && Objects.equals(this.lootTable, that.lootTable) && this.inputs.equals(that.inputs);
    }

    public boolean getMustExist() {
        return this.mustExist;
    }

    public Block getIntermediate() {
        return this.intermediate;
    }

    public boolean getShowTooltip() {
        return this.showTooltip;
    }
}

