/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.crafting.GenericRecipeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecipeAnalyzer {
    public static Map<RecipeType<?>, List<IGenericRecipe>> buildVanillaRecipesMap(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        ArrayList<IGenericRecipe> craftingRecipes = new ArrayList<IGenericRecipe>();
        for (Recipe recipe : recipeManager.m_44054_(RecipeType.f_44107_).values()) {
            if (!recipe.m_8004_(3, 3)) continue;
            RecipeAnalyzer.tryAddingVanillaRecipe(craftingRecipes, recipe, world);
        }
        ArrayList<IGenericRecipe> smeltingRecipes = new ArrayList<IGenericRecipe>();
        for (Recipe recipe : recipeManager.m_44054_(RecipeType.f_44108_).values()) {
            RecipeAnalyzer.tryAddingVanillaRecipe(smeltingRecipes, recipe, world);
        }
        return new ImmutableMap.Builder().put((Object)RecipeType.f_44107_, craftingRecipes).put((Object)RecipeType.f_44108_, smeltingRecipes).build();
    }

    private static void tryAddingVanillaRecipe(@NotNull List<IGenericRecipe> recipes, @NotNull Recipe<?> recipe, @Nullable Level world) {
        if (recipe.m_8043_().m_41619_()) {
            return;
        }
        try {
            IGenericRecipe genericRecipe = GenericRecipeUtils.create(recipe, world);
            if (genericRecipe.getInputs().isEmpty()) {
                return;
            }
            recipes.add(genericRecipe);
        }
        catch (Exception ex) {
            Log.getLogger().warn("Error evaluating recipe " + recipe.m_6423_() + "; ignoring.", (Throwable)ex);
        }
    }

    @NotNull
    public static List<IGenericRecipe> findRecipes(@NotNull Map<RecipeType<?>, List<IGenericRecipe>> vanilla, @NotNull ICraftingBuildingModule crafting) {
        IGenericRecipe safeRecipe;
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        if (crafting.canLearnCraftingRecipes()) {
            for (IGenericRecipe recipe : vanilla.get(RecipeType.f_44107_)) {
                if (!crafting.canLearnLargeRecipes() && recipe.getGridSize() > 2 || !crafting.isRecipeCompatible(safeRecipe = GenericRecipeUtils.filterInputs(recipe, crafting.getIngredientValidator()))) continue;
                recipes.add(safeRecipe);
            }
        }
        if (crafting.canLearnFurnaceRecipes()) {
            for (IGenericRecipe recipe : vanilla.get(RecipeType.f_44108_)) {
                safeRecipe = GenericRecipeUtils.filterInputs(recipe, crafting.getIngredientValidator());
                if (!crafting.isRecipeCompatible(safeRecipe)) continue;
                recipes.add(safeRecipe);
            }
        }
        for (CustomRecipe customRecipe : CustomRecipeManager.getInstance().getRecipes(crafting.getCustomRecipeKey())) {
            IRecipeStorage recipeStorage = customRecipe.getRecipeStorage();
            if (!recipeStorage.getAlternateOutputs().isEmpty()) {
                recipes.removeIf(r -> ItemStackUtils.compareItemStacksIgnoreStackSize(recipeStorage.getPrimaryOutput(), r.getPrimaryOutput()));
                recipes.removeIf(r -> recipeStorage.getAlternateOutputs().stream().anyMatch(s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, r.getPrimaryOutput())));
            }
            recipes.add(GenericRecipeUtils.create(customRecipe, recipeStorage));
        }
        recipes.addAll(crafting.getAdditionalRecipesForDisplayPurposesOnly());
        return recipes;
    }

    private RecipeAnalyzer() {
    }
}

