/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs.views;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;

public class DefaultJobView
implements IJobView {
    private final Set<IToken<?>> asyncRequests = new HashSet();
    private final IColonyView colonyView;
    private JobEntry entry;

    public DefaultJobView(IColonyView iColonyView, ICitizenDataView iCitizenDataView) {
        this.colonyView = iColonyView;
    }

    @Override
    public void deserialize(FriendlyByteBuf buffer) {
        this.asyncRequests.clear();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.asyncRequests.add((IToken)StandardFactoryController.getInstance().deserialize(buffer));
        }
        this.entry = (JobEntry)buffer.readRegistryId();
    }

    @Override
    public String getName() {
        return this.entry.getTranslationKey();
    }

    @Override
    public JobEntry getEntry() {
        return this.entry;
    }

    protected IColonyView getColonyView() {
        return this.colonyView;
    }

    @Override
    public Set<IToken<?>> getAsyncRequests() {
        return this.asyncRequests;
    }

    @Override
    public void setEntry(JobEntry entry) {
        this.entry = entry;
    }
}

