/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.management.StructureName;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IEventStructureManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.managers.EventManager;
import com.minecolonies.coremod.util.CreativeRaiderStructureHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;

public class EventStructureManager
implements IEventStructureManager {
    private static final String TAG_EVENT_STRUCTURE_MANAGER = "eventstructure_manager";
    public static final String STRUCTURE_BACKUP_FOLDER = "structbackup";
    private final Map<BlockPos, Integer> backupSchematics = new HashMap<BlockPos, Integer>();
    private final EventManager eventManager;
    private final IColony colony;

    public EventStructureManager(EventManager eventManager, IColony colony) {
        this.eventManager = eventManager;
        this.colony = colony;
    }

    @Override
    public boolean spawnTemporaryStructure(Blueprint structure, String schematicPath, BlockPos targetSpawnPoint, int eventID, int rotations, Mirror mirror) {
        if (this.eventManager.getEventByID(eventID) == null) {
            return false;
        }
        Level world = this.colony.getWorld();
        int y = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)structure, (int)4) - 1;
        BlockPos spawnPos = targetSpawnPoint.m_142082_(0, -y, 0).m_141952_((Vec3i)structure.getPrimaryBlockOffset());
        BlockPos zeroPos = spawnPos.m_141950_((Vec3i)structure.getPrimaryBlockOffset());
        BlockPos cornerPos = new BlockPos(zeroPos.m_123341_() + structure.getSizeX() - 1, zeroPos.m_123342_() + structure.getSizeY(), zeroPos.m_123343_() + structure.getSizeZ() - 1);
        BlockPos anchor = new BlockPos(zeroPos.m_123341_() + structure.getSizeX() / 2, zeroPos.m_123342_(), zeroPos.m_123343_() + structure.getSizeZ() / 2);
        String backupPath = "schematics/structbackup/" + this.colony.getID() + "/" + this.colony.getDimension().m_135782_().m_135827_() + this.colony.getDimension().m_135782_().m_135815_() + "/" + anchor;
        if (!ItemScanTool.saveStructureOnServer((Level)world, (BlockPos)zeroPos, (BlockPos)cornerPos, (String)backupPath, (boolean)false)) {
            Log.getLogger().info("Failed to save schematics for event");
            return false;
        }
        this.backupSchematics.put(anchor, eventID);
        CreativeRaiderStructureHandler.loadAndPlaceStructureWithRotation(world, schematicPath, spawnPos, BlockPosUtil.getRotationFromRotations(rotations), mirror, true, this.colony.getID(), (IColonyRaidEvent)this.eventManager.getEventByID(eventID), null);
        return true;
    }

    @Override
    public void loadBackupForEvent(int eventID) {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.backupSchematics.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() != eventID) continue;
            String oldBackupPath = String.valueOf(this.colony.getID()) + this.colony.getDimension() + entry.getKey();
            String fileName = new StructureName("cache", "backup", "schematics/structbackup").toString() + "/" + String.valueOf(this.colony.getID()) + "/" + this.colony.getDimension().m_135782_().m_135827_() + this.colony.getDimension().m_135782_().m_135815_() + "/" + entry.getKey();
            if (CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(this.colony.getWorld(), fileName, entry.getKey(), Rotation.NONE, Mirror.NONE, true, null) == null) {
                fileName = new StructureName("cache", "backup", "schematicsstructbackup").toString() + oldBackupPath;
                CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(this.colony.getWorld(), fileName, entry.getKey(), Rotation.NONE, Mirror.NONE, true, null);
            }
            try {
                Structurize.proxy.getSchematicsFolder().toPath().resolve(fileName + ".blueprint").toFile().delete();
            }
            catch (Exception e) {
                Log.getLogger().info("Minor issue: Failed at deleting a backup schematic at " + fileName, (Throwable)e);
            }
            iterator.remove();
        }
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        if (compound.m_128441_(TAG_EVENT_STRUCTURE_MANAGER)) {
            this.backupSchematics.clear();
            CompoundTag structureManagerCompound = compound.m_128469_(TAG_EVENT_STRUCTURE_MANAGER);
            ListTag schematicTags = structureManagerCompound.m_128437_("ships", 10);
            for (Tag base : schematicTags) {
                CompoundTag tagCompound = (CompoundTag)base;
                BlockPos pos = BlockPosUtil.read(tagCompound, "pos");
                int eventID = tagCompound.m_128451_("mc_event_id");
                if (this.eventManager.getEventByID(eventID) != null) {
                    this.backupSchematics.put(pos, eventID);
                    continue;
                }
                this.loadBackupForEvent(eventID);
                Log.getLogger().debug("Discarding schematic backup for event id:" + eventID + " seems the event went missing.");
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        CompoundTag structureManagerCompound = new CompoundTag();
        @NotNull ListTag schematicTagList = new ListTag();
        for (Map.Entry<BlockPos, Integer> entry : this.backupSchematics.entrySet()) {
            CompoundTag entryCompound = new CompoundTag();
            entryCompound.m_128405_("mc_event_id", entry.getValue().intValue());
            BlockPosUtil.write(entryCompound, "pos", entry.getKey());
            schematicTagList.add((Object)entryCompound);
        }
        structureManagerCompound.m_128365_("ships", (Tag)schematicTagList);
        compound.m_128365_(TAG_EVENT_STRUCTURE_MANAGER, (Tag)structureManagerCompound);
    }
}

