/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.util.AdvancementUtils;
import com.minecolonies.coremod.util.ColonyUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkManager
implements IWorkManager {
    private static final String TAG_WORK_ORDERS = "workOrders";
    private final Colony colony;
    @NotNull
    private final Map<Integer, IWorkOrder> workOrders = new LinkedHashMap<Integer, IWorkOrder>();
    private int topWorkOrderId = 0;
    private boolean dirty = false;

    public WorkManager(Colony c) {
        this.colony = c;
    }

    @Override
    public void removeWorkOrder(@NotNull IWorkOrder order) {
        this.removeWorkOrder(order.getID());
    }

    @Override
    public void removeWorkOrder(int orderId) {
        IWorkOrder workOrder = this.workOrders.get(orderId);
        if (workOrder != null) {
            this.workOrders.remove(orderId);
            this.colony.removeWorkOrderInView(orderId);
            workOrder.onRemoved(this.colony);
            this.colony.markDirty();
        }
    }

    @Override
    @Nullable
    public <W extends IWorkOrder> W getWorkOrder(int id, @NotNull Class<W> type) {
        IWorkOrder workOrder = this.getWorkOrder(id);
        if (type.isInstance(workOrder)) {
            return (W)((IWorkOrder)type.cast(workOrder));
        }
        return null;
    }

    @Override
    public IWorkOrder getWorkOrder(int id) {
        return this.workOrders.get(id);
    }

    @Override
    @Nullable
    public <W extends IWorkOrder> W getUnassignedWorkOrder(@NotNull Class<W> type) {
        for (IWorkOrder o : this.workOrders.values()) {
            if (o.isClaimed() || !type.isInstance(o)) continue;
            return (W)((IWorkOrder)type.cast(o));
        }
        return null;
    }

    @Override
    public <W extends IWorkOrder> List<W> getWorkOrdersOfType(@NotNull Class<W> type) {
        return this.workOrders.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Map<Integer, IWorkOrder> getWorkOrders() {
        return this.workOrders;
    }

    @Override
    public void clearWorkForCitizen(@NotNull ICitizenData citizen) {
        this.dirty = true;
        this.workOrders.values().stream().filter(o -> o != null && o.isClaimedBy(citizen)).forEach(IWorkOrder::clearClaimedBy);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag list = new ListTag();
        for (IWorkOrder o : this.workOrders.values()) {
            @NotNull CompoundTag orderCompound = new CompoundTag();
            o.write(orderCompound);
            list.add((Object)orderCompound);
        }
        compound.m_128365_(TAG_WORK_ORDERS, (Tag)list);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.workOrders.clear();
        ListTag list = compound.m_128437_(TAG_WORK_ORDERS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag orderCompound = list.m_128728_(i);
            @Nullable IWorkOrder o = AbstractWorkOrder.createFromNBT(orderCompound, this);
            if (o == null) continue;
            this.addWorkOrder(o, true);
            if (o.isClaimed() && this.colony.getBuildingManager().getBuilding(o.getClaimedBy()) == null) {
                o.clearClaimedBy();
            }
            this.topWorkOrderId = Math.max(this.topWorkOrderId, o.getID());
        }
    }

    @Override
    public void addWorkOrder(@NotNull IWorkOrder order, boolean readingFromNbt) {
        this.dirty = true;
        if (!(order instanceof WorkOrderMiner)) {
            for (IWorkOrder or : this.workOrders.values()) {
                if (!or.getLocation().equals((Object)order.getLocation()) || !or.getStructureName().equals(order.getStructureName())) continue;
                Log.getLogger().warn("Avoiding adding duplicate workOrder");
                this.removeWorkOrder(or);
                break;
            }
            if (!readingFromNbt && !this.isWorkOrderWithinColony(order)) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.workorder.outofcolony", (Object[])new Object[]{order.getDisplayName(), order.getLocation().m_123341_(), order.getLocation().m_123343_()});
                return;
            }
        }
        if (order.getID() == 0) {
            ++this.topWorkOrderId;
            order.setID(this.topWorkOrderId);
        }
        if (!readingFromNbt) {
            StructureName structureName = new StructureName(order.getStructureName());
            if (order instanceof WorkOrderBuilding) {
                int level = order.getTargetLevel();
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, player -> AdvancementTriggers.CREATE_BUILD_REQUEST.trigger((ServerPlayer)player, structureName, level));
            } else if (order instanceof WorkOrderDecoration) {
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, player -> AdvancementTriggers.CREATE_BUILD_REQUEST.trigger((ServerPlayer)player, structureName, 0));
            }
        }
        this.workOrders.put(order.getID(), order);
        order.onAdded(this.colony, readingFromNbt);
    }

    private boolean isWorkOrderWithinColony(IWorkOrder order) {
        Level world = this.colony.getWorld();
        Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(order.getLocation(), world, new LoadOnlyStructureHandler(world, order.getLocation(), order.getStructureName(), new PlacementSettings(), true).getBluePrint(), order.getRotation(), order.isMirrored());
        HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
        int minX = Math.min(((BlockPos)corners.m_14418_()).m_123341_(), ((BlockPos)corners.m_14419_()).m_123341_()) + 1;
        int maxX = Math.max(((BlockPos)corners.m_14418_()).m_123341_(), ((BlockPos)corners.m_14419_()).m_123341_());
        int minZ = Math.min(((BlockPos)corners.m_14418_()).m_123343_(), ((BlockPos)corners.m_14419_()).m_123343_()) + 1;
        int maxZ = Math.max(((BlockPos)corners.m_14418_()).m_123343_(), ((BlockPos)corners.m_14419_()).m_123343_());
        for (int x = minX; x < maxX; x += 16) {
            for (int z = minZ; z < maxZ; z += 16) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                if (chunks.contains(pos)) continue;
                chunks.add(pos);
                IColonyTagCapability colonyCap = (IColonyTagCapability)world.m_6325_(pos.f_45578_, pos.f_45579_).getCapability(IColony.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (colonyCap != null && colonyCap.getOwningColony() == this.colony.getID()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        @NotNull Iterator<IWorkOrder> iter = this.workOrders.values().iterator();
        while (iter.hasNext()) {
            IWorkOrder o = iter.next();
            if (!o.isValid(this.colony)) {
                iter.remove();
                this.dirty = true;
                continue;
            }
            if (!o.isDirty()) continue;
            this.dirty = true;
            o.resetChange();
        }
    }

    @Override
    public <W extends IWorkOrder> List<W> getOrderedList(Class<W> type, BlockPos builder) {
        return this.getOrderedList(type::isInstance, builder).stream().map(m -> m).collect(Collectors.toList());
    }

    @Override
    public List<IWorkOrder> getOrderedList(@NotNull Predicate<IWorkOrder> predicate, BlockPos builder) {
        return this.workOrders.values().stream().filter(o -> !o.isClaimed() || o.getClaimedBy().equals((Object)builder)).filter(predicate).sorted(Comparator.comparingInt(IWorkOrder::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }
}

