/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class WorkOrderMiner
extends AbstractWorkOrder {
    private BlockPos minerBuilding;

    public WorkOrderMiner() {
    }

    public WorkOrderMiner(String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror, BlockPos minerBuilding) {
        super(structureName, workOrderName, WorkOrderType.BUILD, location, rotation, mirror, 0, 1);
        this.minerBuilding = minerBuilding;
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        return this.minerBuilding.equals((Object)citizen.getWorkBuilding().getID());
    }

    @Override
    public boolean canBeMadeBy(IJob<?> job) {
        return job instanceof JobMiner;
    }

    @Override
    public boolean isValid(IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.minerBuilding) != null;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.minerBuilding = BlockPosUtil.read(compound, "pos");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        BlockPosUtil.write(compound, "pos", this.minerBuilding);
    }

    public BlockPos getMinerBuilding() {
        return this.minerBuilding;
    }
}

