/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.types.BarrelType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CompostRecipeCategory
implements IRecipeCategory<CompostRecipe> {
    private final String title = I18n.m_118938_((String)ModBlocks.blockBarrel.m_7705_(), (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final ITickTimer timer;

    public CompostRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(80, 50);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.blockBarrel));
        this.slot = guiHelper.getSlotDrawable();
        this.timer = guiHelper.createTickTimer(60, BarrelType.values().length - 2, false);
    }

    @NotNull
    public static List<CompostRecipe> findRecipes() {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfCompostRecipes().entrySet().stream().map(entry -> CompostRecipe.individualize((Item)entry.getKey(), (CompostRecipe)entry.getValue())).collect(Collectors.toList());
    }

    @NotNull
    public ResourceLocation getUid() {
        return CompostRecipe.ID;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Class<? extends CompostRecipe> getRecipeClass() {
        return CompostRecipe.class;
    }

    public Component getTitle() {
        return new TextComponent(this.title);
    }

    public void setIngredients(@NotNull CompostRecipe recipe, @NotNull IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(@NotNull IRecipeLayout layout, @NotNull CompostRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = layout.getItemStacks();
        itemStacks.init(0, true, 0, 0);
        itemStacks.init(1, false, 62, 0);
        itemStacks.setBackground(0, this.slot);
        itemStacks.setBackground(1, this.slot);
        itemStacks.set(ingredients);
    }

    public void draw(@NotNull CompostRecipe recipe, @NotNull PoseStack matrixStack, double mouseX, double mouseY) {
        BarrelType type = BarrelType.byMetadata(this.timer.getValue());
        BlockState barrel = (BlockState)((BlockState)ModBlocks.blockBarrel.m_49966_().m_61124_((Property)AbstractBlockBarrel.FACING, (Comparable)Direction.SOUTH)).m_61124_(AbstractBlockBarrel.VARIANT, (Comparable)((Object)type));
        RenderHelper.renderBlock(matrixStack, barrel, 40.0f, 20.0f, 100.0f, -30.0f, 20.0f, 25.0f);
    }
}

