/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class JobBasedRecipeCategory<T>
implements IRecipeCategory<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/jei_recipe.png");
    @NotNull
    protected final IJob<?> job;
    @NotNull
    private final ResourceLocation uid;
    @NotNull
    private final ItemStack catalyst;
    @NotNull
    private final IDrawableStatic background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    protected final IDrawableStatic slot;
    @NotNull
    protected final IDrawableStatic chanceSlot;
    @NotNull
    private final EntityCitizen citizen;
    @NotNull
    private final List<FormattedText> description;
    @NotNull
    private final LoadingCache<T, List<InfoBlock>> infoBlocksCache;
    protected static final int WIDTH = 167;
    protected static final int HEIGHT = 120;
    protected static final int CITIZEN_X = 2;
    protected static final int CITIZEN_Y = 46;
    protected static final int CITIZEN_W = 47;
    protected static final int CITIZEN_H = 71;

    protected JobBasedRecipeCategory(@NotNull IJob<?> job, @NotNull ResourceLocation uid, @NotNull ItemStack icon, @NotNull IGuiHelper guiHelper) {
        this.job = job;
        this.uid = uid;
        this.catalyst = icon;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 167, 120);
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        this.slot = guiHelper.getSlotDrawable();
        this.chanceSlot = guiHelper.createDrawable(TEXTURE, 0, 121, 18, 18);
        this.citizen = JobBasedRecipeCategory.createCitizenWithJob(this.job);
        this.description = JobBasedRecipeCategory.wordWrap(JobBasedRecipeCategory.breakLines(JobBasedRecipeCategory.translateDescription("com.minecolonies.coremod.jei." + this.job.getJobRegistryEntry().getRegistryName().m_135815_())));
        this.infoBlocksCache = CacheBuilder.newBuilder().maximumSize(6L).build(new CacheLoader<T, List<InfoBlock>>(){

            @NotNull
            public List<InfoBlock> load(@NotNull T key) {
                return JobBasedRecipeCategory.this.calculateInfoBlocks(key);
            }
        });
    }

    @NotNull
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @NotNull
    protected static ItemStack getCatalyst(@NotNull BuildingEntry building) {
        return new ItemStack(building.getBuildingBlock());
    }

    @NotNull
    public IJob<?> getJob() {
        return this.job;
    }

    @NotNull
    public ResourceLocation getUid() {
        return this.uid;
    }

    @NotNull
    public Component getTitle() {
        return this.getTitleAsTextComponent();
    }

    @NotNull
    public Component getTitleAsTextComponent() {
        return new TranslatableComponent(this.job.getJobRegistryEntry().getTranslationKey());
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public Collection<?> findRecipes(@NotNull Map<RecipeType<?>, List<IGenericRecipe>> vanilla) {
        return Collections.emptyList();
    }

    public void draw(@NotNull T recipe, @NotNull PoseStack matrixStack, double mouseX, double mouseY) {
        float scale = 29.583332f;
        int citizen_cx = 25;
        int citizen_cy = 81;
        int citizen_by = 117;
        int offsetY = 4;
        float headYaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 40.0f;
        float yaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 20.0f;
        float pitch = (float)Math.atan((77.0 - mouseY) / 40.0) * 20.0f;
        RenderHelper.scissor(matrixStack, 2, 46, 47, 71);
        RenderHelper.renderEntity(matrixStack, 25, 113, 29.583332061767578, headYaw, yaw, pitch, (LivingEntity)this.citizen);
        RenderHelper.stopScissor();
        int y = 0;
        Minecraft mc = Minecraft.m_91087_();
        for (FormattedText line : this.description) {
            boolean x = false;
            mc.f_91062_.m_92877_(matrixStack, Language.m_128107_().m_5536_(line), 0.0f, (float)y, ChatFormatting.BLACK.m_126665_().intValue());
            Objects.requireNonNull(mc.f_91062_);
            y += 9 + 2;
        }
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            mc.f_91062_.m_92750_(matrixStack, block.text, (float)block.bounds.m_110085_(), (float)block.bounds.m_110086_(), ChatFormatting.YELLOW.m_126665_().intValue());
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull T recipe, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            if (block.tip == null || !block.bounds.m_110087_((int)mouseX, (int)mouseY)) continue;
            tooltips.add((Component)new TextComponent(block.tip));
        }
        return tooltips;
    }

    @NotNull
    private List<InfoBlock> calculateInfoBlocks(@NotNull T recipe) {
        List<Component> lines = this.generateInfoBlocks(recipe);
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<InfoBlock> result = new ArrayList<InfoBlock>();
        int y = 46;
        for (Component line : lines) {
            String key;
            String text = line.getString();
            int width = (int)mc.f_91062_.m_92865_().m_92353_(text);
            Objects.requireNonNull(mc.f_91062_);
            int height = 9;
            int x = 167 - width;
            String tip = null;
            if (line instanceof TranslatableComponent && I18n.m_118936_((String)(key = ((TranslatableComponent)line).m_131328_() + ".tip"))) {
                tip = new TranslatableComponent(key, ((TranslatableComponent)line).m_131329_()).getString();
            }
            result.add(new InfoBlock(text, tip, new Rect2i(x, y, width, height)));
            y += height + 2;
        }
        return result;
    }

    @NotNull
    protected abstract List<Component> generateInfoBlocks(@NotNull T var1);

    @NotNull
    private static EntityCitizen createCitizenWithJob(@NotNull IJob<?> job) {
        EntityCitizen citizen = new EntityCitizen(ModEntities.CITIZEN, (Level)Minecraft.m_91087_().f_91073_);
        citizen.setFemale(citizen.m_21187_().nextBoolean());
        citizen.setTextureId(citizen.m_21187_().nextInt(255));
        citizen.m_20088_().m_135381_(EntityCitizen.DATA_TEXTURE_SUFFIX, (Object)CitizenData.SUFFIXES.get(citizen.m_21187_().nextInt(CitizenData.SUFFIXES.size())));
        citizen.setModelId(job.getModel());
        return citizen;
    }

    @NotNull
    private static List<FormattedText> translateDescription(String ... keys) {
        return Arrays.stream(keys).map(TranslatableComponent::new).collect(Collectors.toList());
    }

    @NotNull
    private static List<FormattedText> breakLines(@NotNull List<FormattedText> input) {
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        for (FormattedText component : input) {
            Optional expanded = component.m_5651_(line -> Optional.of(line.split("\\\\n")));
            expanded.ifPresent(e -> lines.addAll(Arrays.stream(e).map(TextComponent::new).collect(Collectors.toList())));
        }
        return lines;
    }

    @NotNull
    private static List<FormattedText> wordWrap(@NotNull List<FormattedText> input) {
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        for (FormattedText component : input) {
            lines.addAll(mc.f_91062_.m_92865_().m_92414_(component, 167, Style.f_131099_));
        }
        return lines;
    }

    private static class InfoBlock {
        public final String text;
        public final String tip;
        public final Rect2i bounds;

        public InfoBlock(String text, String tip, Rect2i bounds) {
            this.text = text;
            this.tip = tip;
            this.bounds = bounds;
        }
    }

    protected static class LootTableTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private final int firstSlot;
        private final List<LootTableAnalyzer.LootDrop> drops;
        private final ResourceLocation id;

        public LootTableTooltipCallback(int firstSlot, List<LootTableAnalyzer.LootDrop> drops, ResourceLocation id) {
            this.firstSlot = firstSlot;
            this.drops = drops;
            this.id = id;
        }

        public void onTooltip(int slot, boolean input, @NotNull ItemStack stack, @NotNull List<Component> tooltip) {
            int index = slot - this.firstSlot;
            if (index >= 0 && index < this.drops.size()) {
                boolean showAdvanced;
                LootTableAnalyzer.LootDrop drop = this.drops.get(index);
                String key = "com.minecolonies.coremod.jei." + (drop.getQuality() < 0.0f ? "chancenegskill.tip" : (drop.getQuality() > 0.0f ? "chanceskill.tip" : "chance.tip"));
                float probability = drop.getProbability() * 100.0f;
                if (probability >= 1.0f) {
                    tooltip.add((Component)new TranslatableComponent(key, new Object[]{Math.round(probability)}));
                } else {
                    tooltip.add((Component)new TranslatableComponent(key, new Object[]{Float.valueOf((float)Math.round(probability * 100.0f) / 100.0f)}));
                }
                if (drop.getConditional()) {
                    tooltip.add((Component)new TranslatableComponent("com.minecolonies.coremod.jei.conditions.tip"));
                }
                boolean bl = showAdvanced = Minecraft.m_91087_().f_91066_.f_92125_ || Screen.m_96638_();
                if (showAdvanced) {
                    TranslatableComponent recipeId = new TranslatableComponent("com.minecolonies.coremod.jei.loottableid", new Object[]{this.id.toString()});
                    tooltip.add((Component)recipeId.m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    protected static class RecipeIdTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private final int slot;
        private final ResourceLocation id;
        private final IModIdHelper modIdHelper;

        public RecipeIdTooltipCallback(int slot, ResourceLocation id, IModIdHelper modIdHelper) {
            this.slot = slot;
            this.id = id;
            this.modIdHelper = modIdHelper;
        }

        public void onTooltip(int slotIndex, boolean input, @NotNull ItemStack ingredient, @NotNull List<Component> tooltip) {
            boolean showAdvanced;
            String ingredientModId;
            String recipeModId;
            if (slotIndex != this.slot) {
                return;
            }
            if (this.modIdHelper.isDisplayingModNameEnabled() && !(recipeModId = this.id.m_135827_()).equals(ingredientModId = ingredient.m_41720_().getRegistryName().m_135827_())) {
                String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                TranslatableComponent recipeBy = new TranslatableComponent("jei.tooltip.recipe.by", new Object[]{modName});
                tooltip.add((Component)recipeBy.m_130940_(ChatFormatting.GRAY));
            }
            boolean bl = showAdvanced = Minecraft.m_91087_().f_91066_.f_92125_ || Screen.m_96638_();
            if (showAdvanced) {
                TranslatableComponent recipeId = new TranslatableComponent("jei.tooltip.recipe.id", new Object[]{this.id.toString()});
                tooltip.add((Component)recipeId.m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

