/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.ScarecrowFieldStage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.colony.buildings.modules.FarmerFieldModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.CompostParticleMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int STANDARD_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private static final int MAX_DEPTH = 5;
    private static final VisibleCitizenStatus FARMING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/farmer.png"), "com.minecolonies.gui.visiblestatus.farmer");
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int cell = -1;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 10), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForFarming, 20), new AITarget((IAIState)AIWorkerState.FARMER_HOE, this::workAtField, 5), new AITarget((IAIState)AIWorkerState.FARMER_PLANT, this::workAtField, 5), new AITarget((IAIState)AIWorkerState.FARMER_HARVEST, this::workAtField, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingFarmer> getExpectedBuildingClass() {
        return BuildingFarmer.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    protected IAIState decide() {
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING && nextState != AIWorkerState.IDLE) {
            return nextState;
        }
        if (this.wantInventoryDumped()) {
            return this.getState();
        }
        if (((JobFarmer)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.PREPARING;
        }
        if (((JobFarmer)this.job).getCurrentTask() == null) {
            return AIWorkerState.PREPARING;
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    @NotNull
    private IAIState prepareForFarming() {
        int amountOfCompostInInv;
        int amountOfCompostInBuilding;
        @Nullable BuildingFarmer building = (BuildingFarmer)this.getOwnBuilding();
        if (building == null || building.getBuildingLevel() < 1) {
            return AIWorkerState.PREPARING;
        }
        if (!((JobFarmer)this.job).getTaskQueue().isEmpty() || this.getActionsDoneUntilDumping() <= ((JobFarmer)this.job).getActionsDone()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        FarmerFieldModule module = building.getFirstModuleOccurance(FarmerFieldModule.class);
        module.syncWithColony(this.world);
        if (module.getFarmerFields().size() < ((BuildingFarmer)this.getOwnBuilding()).getBuildingLevel() && !module.assignManually()) {
            this.searchAndAddFields();
        }
        if (module.getFarmerFields().size() == ((BuildingFarmer)this.getOwnBuilding()).getMaxBuildingLevel()) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(building.getColony(), AdvancementTriggers.MAX_FIELDS::trigger);
        }
        if ((amountOfCompostInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), this::isCompost)) + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) <= 0) {
            if (((BuildingFarmer)this.getOwnBuilding()).requestFertilizer() && !((BuildingFarmer)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                ArrayList<ItemStack> compostAbleItems = new ArrayList<ItemStack>();
                compostAbleItems.add(new ItemStack((ItemLike)ModItems.compost, 1));
                compostAbleItems.add(new ItemStack((ItemLike)Items.f_42499_, 1));
                this.worker.getCitizenData().createRequestAsync(new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer", 64, 1));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isCompost, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (module.hasNoFields()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("entity.farmer.nofreefields"), ChatPriority.BLOCKING));
            }
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setIdleAtJob(false);
        if (module.getCurrentField() == null && module.getFieldToWorkOn(this.world) == null) {
            module.resetFields();
            return AIWorkerState.IDLE;
        }
        @Nullable BlockPos currentField = module.getCurrentField();
        BlockEntity entity = this.world.m_7702_(currentField);
        if (entity instanceof ScarecrowTileEntity && ((ScarecrowTileEntity)entity).needsWork()) {
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowFieldStage.PLANTED && this.checkIfShouldExecute((ScarecrowTileEntity)entity, pos -> this.findHarvestableSurface((BlockPos)pos) != null)) {
                return AIWorkerState.FARMER_HARVEST;
            }
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowFieldStage.HOED) {
                return this.canGoPlanting((ScarecrowTileEntity)entity, building);
            }
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowFieldStage.EMPTY && this.checkIfShouldExecute((ScarecrowTileEntity)entity, pos -> this.findHoeableSurface((BlockPos)pos, (ScarecrowTileEntity)entity) != null)) {
                return AIWorkerState.FARMER_HOE;
            }
            ((ScarecrowTileEntity)entity).nextState();
        } else {
            module.setCurrentField(null);
        }
        return AIWorkerState.PREPARING;
    }

    private boolean isCompost(ItemStack itemStack) {
        if (itemStack.m_41720_() == ModItems.compost) {
            return true;
        }
        return itemStack.m_41720_() == Items.f_42499_;
    }

    private void searchAndAddFields() {
        AbstractScarecrowTileEntity newField;
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony != null && (newField = colony.getBuildingManager().getFreeField(this.worker.getCitizenData().getId(), this.world)) != null) {
            newField.setOwner(this.worker.getCitizenData().getId());
            newField.setTaken(true);
            newField.m_6596_();
            FarmerFieldModule module = ((BuildingFarmer)this.getOwnBuilding()).getFirstModuleOccurance(FarmerFieldModule.class);
            module.addFarmerFields(newField.getPosition());
        }
    }

    private boolean checkIfShouldExecute(@NotNull ScarecrowTileEntity field, @NotNull Predicate<BlockPos> predicate) {
        BlockPos position;
        do {
            this.workingOffset = this.nextValidCell(field);
            if (this.workingOffset != null) continue;
            return false;
        } while (!predicate.test(position = field.m_58899_().m_7495_().m_142383_(this.workingOffset.m_123343_()).m_142385_(this.workingOffset.m_123341_())));
        return true;
    }

    private IAIState canGoPlanting(@NotNull ScarecrowTileEntity currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null || currentField.getSeed().m_41619_()) {
            this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((Component)new TranslatableComponent("entity.farmer.noseedset", new Object[]{currentField.m_58899_()}), ChatPriority.BLOCKING, (Component)new TranslatableComponent("entity.farmer.noseedset"), currentField.m_58899_()));
            FarmerFieldModule module = buildingFarmer.getFirstModuleOccurance(FarmerFieldModule.class);
            module.setCurrentField(null);
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setIdleAtJob(false);
        ItemStack seeds = currentField.getSeed().m_41777_();
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(seeds.m_41720_());
        if (slot != -1) {
            return AIWorkerState.FARMER_PLANT;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.PREPARING;
        }
        seeds.m_41764_(seeds.m_41741_());
        this.checkIfRequestForItemExistOrCreateAsync(seeds, seeds.m_41741_(), 1);
        currentField.nextState();
        return AIWorkerState.PREPARING;
    }

    private BlockPos findHoeableSurface(@NotNull BlockPos position, @NotNull ScarecrowTileEntity field) {
        if ((position = this.getSurfacePos(position)) == null || field.isNoPartOfField(this.world, position) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof CropBlock || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof BlockScarecrow || !this.world.m_8055_(position).m_204336_(BlockTags.f_144274_)) {
            return null;
        }
        return position;
    }

    private BlockPos getSurfacePos(BlockPos position) {
        return this.getSurfacePos(position, 0);
    }

    private BlockPos getSurfacePos(BlockPos position, Integer depth) {
        if (Math.abs(depth) > 5) {
            return null;
        }
        BlockState curBlockState = this.world.m_8055_(position);
        @Nullable Block curBlock = curBlockState.m_60734_();
        if (curBlockState.m_60767_().m_76333_() && !(curBlock instanceof PumpkinBlock) && !(curBlock instanceof MelonBlock) && !(curBlock instanceof WebBlock) || curBlockState.m_60767_().m_76332_()) {
            if (depth < 0) {
                return position;
            }
            return this.getSurfacePos(position.m_7494_(), depth + 1);
        }
        if (depth > 0) {
            return position.m_7495_();
        }
        return this.getSurfacePos(position.m_7495_(), depth - 1);
    }

    protected BlockPos nextValidCell(AbstractScarecrowTileEntity field) {
        int x;
        int z;
        if (this.workingOffset == null) {
            this.cell = -1;
        }
        do {
            if (++this.cell == this.getLargestCell()) {
                return null;
            }
            int ring = (int)Math.floor((Math.sqrt(this.cell + 1) + 1.0) / 2.0);
            int ringCell = this.cell - (int)(4.0 * Math.pow(ring - 1, 2.0) + (double)(4 * (ring - 1)));
            Direction facing = Direction.m_122407_((int)Math.floorDiv(ringCell, 2 * ring));
            if (facing.m_122434_() == Direction.Axis.Z) {
                x = (facing == Direction.NORTH ? -1 : 1) * (ring - ringCell % (2 * ring));
                z = (facing == Direction.NORTH ? -1 : 1) * ring;
                continue;
            }
            x = (facing == Direction.WEST ? -1 : 1) * ring;
            z = (facing == Direction.EAST ? -1 : 1) * (ring - ringCell % (2 * ring));
        } while (-z > field.getRadius(Direction.NORTH) || x > field.getRadius(Direction.EAST) || z > field.getRadius(Direction.SOUTH) || -x > field.getRadius(Direction.WEST));
        return new BlockPos(x, 0, z);
    }

    protected int getLargestCell() {
        return (int)Math.pow(ScarecrowTileEntity.getMaxRange() * 2 + 1, 2.0);
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory || this.job != null && ((JobFarmer)this.job).getActionsDone() >= this.getActionRewardForCraftingSuccess()) {
            this.shouldDumpInventory = false;
            return true;
        }
        return super.wantInventoryDumped();
    }

    private IAIState workAtField() {
        @Nullable BuildingFarmer buildingFarmer = (BuildingFarmer)this.getOwnBuilding();
        FarmerFieldModule module = buildingFarmer.getFirstModuleOccurance(FarmerFieldModule.class);
        if (this.checkForToolOrWeapon(ToolType.HOE) || module.getCurrentField() == null) {
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
        @Nullable BlockPos field = module.getCurrentField();
        BlockEntity entity = this.world.m_7702_(field);
        if (entity instanceof ScarecrowTileEntity) {
            ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)entity;
            if (this.workingOffset != null) {
                if (scarecrow.getOwnerId() != this.worker.getCivilianID()) {
                    module.freeField(module.getCurrentField());
                    module.setCurrentField(null);
                    return this.getState();
                }
                BlockPos position = field.m_7495_().m_142383_(this.workingOffset.m_123343_()).m_142385_(this.workingOffset.m_123341_());
                if (this.walkToBlock(position.m_7494_())) {
                    return this.getState();
                }
                switch ((AIWorkerState)this.getState()) {
                    case FARMER_HOE: {
                        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.coremod.status.hoeing")});
                        if (this.hoeIfAble(position, scarecrow)) break;
                        return this.getState();
                    }
                    case FARMER_PLANT: {
                        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.coremod.status.planting")});
                        if (this.tryToPlant(scarecrow, position)) break;
                        return AIWorkerState.PREPARING;
                    }
                    case FARMER_HARVEST: {
                        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.coremod.status.harvesting")});
                        if (this.harvestIfAble(position)) break;
                        return this.getState();
                    }
                    default: {
                        return AIWorkerState.PREPARING;
                    }
                }
                this.prevPos = position;
                this.setDelay(this.getLevelDelay());
            }
            this.workingOffset = this.nextValidCell(scarecrow);
            if (this.workingOffset == null) {
                this.shouldDumpInventory = true;
                scarecrow.nextState();
                this.prevPos = null;
                return AIWorkerState.IDLE;
            }
        } else {
            return AIWorkerState.IDLE;
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position, ScarecrowTileEntity field) {
        if ((position = this.findHoeableSurface(position, field)) != null && !this.checkForToolOrWeapon(ToolType.HOE)) {
            if (this.mineBlock(position.m_7494_())) {
                this.equipHoe();
                this.worker.m_6674_(this.worker.m_7655_());
                this.world.m_46597_(position, Blocks.f_50093_.m_49966_());
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    private boolean harvestIfAble(BlockPos position) {
        if ((position = this.findHarvestableSurface(position)) != null) {
            if (Compatibility.isPamsInstalled()) {
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
                this.harvestCrop(position.m_7494_());
                return true;
            }
            if (this.mineBlock(position.m_7494_())) {
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
            } else {
                return false;
            }
        }
        return true;
    }

    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.getPrimarySkillLevel() / 2.0 * 1.0);
    }

    private boolean tryToPlant(ScarecrowTileEntity field, BlockPos position) {
        return (position = this.findPlantableSurface(position, field)) == null || this.plantCrop(field.getSeed(), position);
    }

    private void equipHoe() {
        this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, this.getHoeSlot());
    }

    private BlockPos findPlantableSurface(@NotNull BlockPos position, @NotNull ScarecrowTileEntity field) {
        if ((position = this.getSurfacePos(position)) == null || field.isNoPartOfField(this.world, position) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof CropBlock || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof StemBlock || this.world.m_8055_(position).m_60734_() instanceof BlockScarecrow || !(this.world.m_8055_(position).m_60734_() instanceof FarmBlock)) {
            return null;
        }
        return position;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        if (item == null || item.m_41619_()) {
            return false;
        }
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(item.m_41720_());
        if (slot == -1) {
            return false;
        }
        if (item.m_41720_() instanceof BlockItem && (((BlockItem)item.m_41720_()).m_40614_() instanceof CropBlock || ((BlockItem)item.m_41720_()).m_40614_() instanceof StemBlock)) {
            @NotNull Item seed = item.m_41720_();
            if (!(seed != Items.f_42578_ && seed != Items.f_42577_ || this.prevPos == null || this.world.m_46859_(this.prevPos.m_7494_()))) {
                return true;
            }
            this.world.m_46597_(position.m_7494_(), ((BlockItem)item.m_41720_()).m_40614_().m_49966_());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
        }
        return true;
    }

    private BlockPos findHarvestableSurface(@NotNull BlockPos position) {
        if ((position = this.getSurfacePos(position)) == null) {
            return null;
        }
        BlockState state = this.world.m_8055_(position.m_7494_());
        Block block = state.m_60734_();
        if (block == Blocks.f_50133_ || block == Blocks.f_50186_) {
            return position;
        }
        if (this.isCrop(block)) {
            @NotNull CropBlock crop = (CropBlock)block;
            if (crop.m_52307_(state)) {
                return position;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return null;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                Network.getNetwork().sendToPosition(new CompostParticleMessage(position.m_7494_()), new PacketDistributor.TargetPoint((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 16.0, this.world.m_46472_()));
                crop.m_52263_(this.world, position.m_7494_(), state);
                state = this.world.m_8055_(position.m_7494_());
                block = state.m_60734_();
                if (this.isCrop(block)) {
                    crop = (CropBlock)block;
                } else {
                    return null;
                }
            }
            return crop.m_52307_(state) ? position : null;
        }
        return null;
    }

    public boolean isCrop(Block block) {
        return block instanceof CropBlock;
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        if (this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING) > 0.0) {
            return drops;
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            ItemStack drop = stack.m_41777_();
            if (this.worker.m_21187_().nextDouble() < this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING)) {
                drop.m_41764_(drop.m_41613_() * 2);
            }
            newDrops.add(drop);
        }
        return newDrops;
    }

    private void harvestCrop(@NotNull BlockPos pos) {
        ItemStack tool = this.worker.m_21205_();
        int fortune = ItemStackUtils.getFortuneOf(tool);
        BlockState state = this.world.m_8055_(pos);
        double chance = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING);
        NonNullList drops = NonNullList.m_122779_();
        state.m_60724_(new LootContext.Builder((ServerLevel)this.world).m_78963_((float)fortune).m_78963_((float)fortune).m_78972_(LootContextParams.f_81460_, (Object)this.worker.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78972_(LootContextParams.f_81455_, (Object)this.getCitizen()));
        for (ItemStack item : drops) {
            ItemStack drop = item.m_41777_();
            if (this.worker.m_21187_().nextDouble() < chance) {
                drop.m_41764_(drop.m_41613_() * 2);
            }
            InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), drop);
        }
        if (state.m_60734_() instanceof CropBlock) {
            CropBlock crops = (CropBlock)state.m_60734_();
            this.world.m_46597_(pos, crops.m_52289_(0));
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.HOE, 0, ((BuildingFarmer)this.getOwnBuilding()).getMaxToolLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

