/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.miner.MinerLevel;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.util.AdvancementUtils;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructureWithWorkOrder<JobMiner, BuildingMiner> {
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private static final int COBBLE_REQUEST_BATCHES = 32;
    private static final int LADDER_REQUEST_BATCHES = 10;
    private static final String RENDER_META_TORCH = "torch";
    private static final String RENDER_META_STONE = "stone";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 64;
    public static final int SHAFT_RADIUS = 3;
    private static final int SAFE_CHECK_RANGE = 5;
    private static final int SHAFT_BASE_DEPTH = 8;
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int ROTATE_FOUR_TIMES = 4;
    private static final int LIQUID_CHECK_RANGE = 5;
    private static final VisibleCitizenStatus MINING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/miner.png"), "com.minecolonies.gui.visiblestatus.miner");
    @Nullable
    private BlockPos minerWorkingLocation;
    @Nullable
    private BlockPos currentStandingPosition;
    @Nullable
    private Node workingNode = null;

    public EntityAIStructureMiner(@NotNull JobMiner job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, AIWorkerState.MINER_CHECK_MINESHAFT, 1), new AITarget((IAIState)AIWorkerState.MINER_WALKING_TO_LADDER, this::goToLadder, 20), new AITarget((IAIState)AIWorkerState.MINER_REPAIRING_LADDER, this::repairLadder, 5), new AITarget((IAIState)AIWorkerState.MINER_CHECK_MINESHAFT, this::checkMineShaft, 20), new AITarget((IAIState)AIWorkerState.MINER_MINING_SHAFT, this::doShaftMining, 5), new AITarget((IAIState)AIWorkerState.MINER_BUILDING_SHAFT, this::doShaftBuilding, 5), new AITarget((IAIState)AIWorkerState.MINER_MINING_NODE, this::executeNodeMining, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingMiner> getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @NotNull
    private IAIState startWorkingAtOwnBuilding() {
        List<WorkOrderMiner> list;
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if ((((BuildingMiner)this.getOwnBuilding()).getLadderLocation() == null || this.worker.m_20186_() >= (double)((BuildingMiner)this.getOwnBuilding()).getPosition().m_123342_()) && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((BuildingMiner)this.getOwnBuilding()).getLadderLocation() == null || ((BuildingMiner)this.getOwnBuilding()).getCobbleLocation() == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("entity.miner.invalidmineshaft"), ChatPriority.BLOCKING));
            return AIWorkerState.START_WORKING;
        }
        if (!((JobMiner)this.job).hasWorkOrder() && !(list = ((BuildingMiner)this.getOwnBuilding()).getColony().getWorkManager().getOrderedList(WorkOrderMiner.class, ((BuildingMiner)this.getOwnBuilding()).getPosition())).isEmpty()) {
            ((JobMiner)this.job).setWorkOrder(list.get(0));
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.PREPARING;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return ((BuildingMiner)this.getOwnBuilding()).getBuildingLevel() * 64;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getRenderMetaStone() + this.getRenderMetaTorch());
    }

    @NotNull
    private String getRenderMetaTorch() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42000_)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @NotNull
    private String getRenderMetaStone() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(this.getMainFillBlock())) {
            return RENDER_META_STONE;
        }
        return "";
    }

    @Override
    public IAIState doMining() {
        if (this.blockToMine == null) {
            return AIWorkerState.BUILDING_STEP;
        }
        for (Direction direction : Direction.values()) {
            BlockPos pos = this.blockToMine.m_142300_(direction);
            BlockState surroundingState = this.world.m_8055_(pos);
            FluidState fluid = this.world.m_6425_(pos);
            if (surroundingState.m_60734_() != Blocks.f_49991_ && (fluid == null || fluid.m_76178_() || fluid.m_76152_() != Fluids.f_76195_ && fluid.m_76152_() != Fluids.f_76194_) && !SurfaceType.isWater((BlockGetter)this.world, pos, surroundingState, fluid)) continue;
            this.setBlockFromInventory(pos, this.getMainFillBlock());
        }
        BlockState blockState = this.world.m_8055_(this.blockToMine);
        if (!IColonyManager.getInstance().getCompatibilityManager().isOre(blockState)) {
            this.blockToMine = this.getSurroundingOreOrDefault(this.blockToMine);
        }
        if (this.world.m_8055_(this.blockToMine).m_60734_() instanceof AirBlock) {
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            return this.getState();
        }
        this.blockToMine = this.getSurroundingOreOrDefault(this.blockToMine);
        if (IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.m_8055_(this.blockToMine))) {
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        return AIWorkerState.BUILDING_STEP;
    }

    @Override
    public boolean shouldSilkTouchBlock(BlockState curBlockState) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(curBlockState);
    }

    private BlockPos getSurroundingOreOrDefault(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.m_142300_(direction);
            if (!IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.m_8055_(offset))) continue;
            return offset;
        }
        return pos;
    }

    @NotNull
    private IAIState goToLadder() {
        if (this.walkToLadder()) {
            return AIWorkerState.MINER_WALKING_TO_LADDER;
        }
        return AIWorkerState.MINER_REPAIRING_LADDER;
    }

    private boolean walkToLadder() {
        return this.walkToBlock(((BuildingMiner)this.getOwnBuilding()).getLadderLocation());
    }

    @NotNull
    private IAIState repairLadder() {
        @NotNull BlockPos nextCobble = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().m_123343_());
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123343_());
        @NotNull BlockPos safeStand = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world), ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123343_());
        if (!this.world.m_8055_(nextCobble).m_60815_()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)this.getSolidSubstitution(nextCobble).m_60734_()), 32, 1)) {
                return this.getState();
            }
            if (!this.world.m_8055_(nextCobble).m_60795_() && !this.mineBlock(nextCobble, safeStand)) {
                return this.getState();
            }
            this.setBlockFromInventory(nextCobble, this.getLadderBackFillBlock());
            return this.getState();
        }
        if (!this.world.m_8055_(nextLadder).isLadder((LevelReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.m_8055_(nextLadder).m_60815_()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)Blocks.f_50155_), 10, 1)) {
                return this.getState();
            }
            if (!this.world.m_8055_(nextLadder).m_60795_() && !this.mineBlock(nextLadder, safeStand)) {
                return this.getState();
            }
            BlockState metadata = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.m_122372_((float)(nextLadder.m_123341_() - nextCobble.m_123341_()), (float)0.0f, (float)(nextLadder.m_123343_() - nextCobble.m_123343_())));
            this.setBlockFromInventory(nextLadder, Blocks.f_50155_, metadata);
            return this.getState();
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private Block getMainFillBlock() {
        return ((BuildingMiner)this.getOwnBuilding()).getSetting(BuildingMiner.FILL_BLOCK).getValue().m_40614_();
    }

    private Block getLadderBackFillBlock() {
        if (WorldUtil.isNetherType(this.world)) {
            return Blocks.f_50134_;
        }
        return Blocks.f_50652_;
    }

    @NotNull
    private IAIState checkMineShaft() {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) < this.world.m_141937_() + 8) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(((JobMiner)this.job).getColony(), AdvancementTriggers.DEEP_MINE::trigger);
        }
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) < buildingMiner.getDepthLimit(this.world)) {
            if (buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class).getNumberOfLevels() == 0) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("entity.miner.messagerequiresbetterhut"), ChatPriority.BLOCKING));
                return AIWorkerState.IDLE;
            }
            this.worker.getCitizenData().setVisibleStatus(MINING);
            return AIWorkerState.MINER_MINING_NODE;
        }
        this.worker.getCitizenData().setVisibleStatus(MINING);
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(Math.max(super.getTotalAmount(stack).m_41613_(), copy.m_41741_() / 2));
        return copy;
    }

    private IAIState doShaftMining() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.coremod.status.mining")});
        this.minerWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.minerWorkingLocation == null) {
            return this.advanceLadder(AIWorkerState.MINER_MINING_SHAFT);
        }
        if (this.mineBlock(this.minerWorkingLocation, this.currentStandingPosition)) {
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    private IAIState advanceLadder(IAIState state) {
        if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)this.getLadderBackFillBlock()), 32, 1) || !this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)Blocks.f_50155_), 10, 1)) {
            return state;
        }
        if (this.ladderDamaged()) {
            return AIWorkerState.MINER_REPAIRING_LADDER;
        }
        BlockPos vector = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_141950_((Vec3i)((BuildingMiner)this.getOwnBuilding()).getCobbleLocation());
        int xOffset = 3 * vector.m_123341_();
        int zOffset = 3 * vector.m_123343_();
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123343_());
        @NotNull BlockPos safeCobble = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 2, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123343_());
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                @NotNull BlockPos curBlock = new BlockPos(safeCobble.m_123341_() + x + xOffset, safeCobble.m_123342_(), safeCobble.m_123343_() + z + zOffset);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        @NotNull BlockPos safeStand = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world), ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123343_());
        @NotNull BlockPos nextCobble = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().m_123343_());
        MinerLevelManagementModule module = ((BuildingMiner)this.getOwnBuilding()).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (module.getStartingLevelShaft() == 0) {
            module.setStartingLevelShaft(nextCobble.m_123342_() - 4);
        }
        if (nextCobble.m_123342_() < module.getStartingLevelShaft()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        if (!this.mineBlock(nextCobble, safeStand) && !this.world.m_8055_(nextCobble).m_60767_().m_76336_() || !this.mineBlock(nextLadder, safeStand) && !this.world.m_8055_(nextLadder).m_60767_().m_76336_()) {
            return state;
        }
        BlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, this.getLadderBackFillBlock());
        this.setBlockFromInventory(nextLadder, Blocks.f_50155_, metadata);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private BlockState getBlockState(@NotNull BlockPos pos) {
        return this.world.m_8055_(pos);
    }

    @Nullable
    private BlockPos getNextBlockInShaftToMine() {
        double distance;
        BlockPos curBlock;
        int z;
        int x;
        Block block;
        BlockPos ladderPos = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world);
        if (this.minerWorkingLocation == null) {
            this.minerWorkingLocation = new BlockPos(ladderPos.m_123341_(), lastLadder + 1, ladderPos.m_123343_());
        }
        if (!((block = this.getBlock(this.minerWorkingLocation)) instanceof AirBlock || block == Blocks.f_50155_ || block.equals(Blocks.f_49990_) || block.equals(Blocks.f_49991_))) {
            if (this.currentStandingPosition == null) {
                this.currentStandingPosition = this.minerWorkingLocation;
            }
            return this.minerWorkingLocation;
        }
        this.currentStandingPosition = this.minerWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        BlockPos vector = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_141950_((Vec3i)((BuildingMiner)this.getOwnBuilding()).getCobbleLocation());
        int xOffset = 3 * vector.m_123341_();
        int zOffset = 3 * vector.m_123343_();
        for (x = 3 + xOffset + 2; x >= -3 + xOffset - 2; --x) {
            for (z = -3 + zOffset - 2; z <= 3 + zOffset + 2; ++z) {
                if (x == 0 && 0 == z || !(block = this.getBlock(curBlock = new BlockPos(ladderPos.m_123341_() + x, lastLadder, ladderPos.m_123343_() + z))).equals(Blocks.f_49990_) && !block.equals(Blocks.f_49991_)) continue;
                this.setBlockFromInventory(curBlock, this.getMainFillBlock());
            }
        }
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                curBlock = new BlockPos(ladderPos.m_123341_() + x, lastLadder, ladderPos.m_123343_() + z);
                distance = curBlock.m_123331_((Vec3i)ladderPos) + Math.pow(curBlock.m_123331_((Vec3i)this.minerWorkingLocation), 2.0);
                block = this.getBlock(curBlock);
                if (!(distance < bestDistance) || this.world.m_46859_(curBlock)) continue;
                if (block.equals(Blocks.f_49990_) || block.equals(Blocks.f_49991_)) {
                    this.setBlockFromInventory(curBlock, this.getMainFillBlock());
                }
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.m_123341_() + x, lastLadder, nextBlockToMine.m_123343_() + z)).m_123331_((Vec3i)ladderPos)) < bestDistance) || !this.world.m_46859_(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    @NotNull
    private IAIState doShaftBuilding() {
        if (this.walkToBuilding()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        BlockPos ladderPos = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world) + 1;
        BlockPos vector = ladderPos.m_141950_((Vec3i)((BuildingMiner)this.getOwnBuilding()).getCobbleLocation());
        int xOffset = 3 * vector.m_123341_();
        int zOffset = 3 * vector.m_123343_();
        BuildingMiner.initStructure(null, 0, new BlockPos(ladderPos.m_123341_() + xOffset, lastLadder + 1, ladderPos.m_123343_() + zOffset), (BuildingMiner)this.getOwnBuilding(), this.world, (JobMiner)this.job);
        return AIWorkerState.LOAD_STRUCTURE;
    }

    @NotNull
    private IAIState executeNodeMining() {
        MinerLevelManagementModule module = ((BuildingMiner)this.getOwnBuilding()).getFirstModuleOccurance(MinerLevelManagementModule.class);
        @Nullable MinerLevel currentLevel = module.getCurrentLevel();
        if (currentLevel == null) {
            Log.getLogger().warn("Current Level not set, resetting...");
            module.setCurrentLevel(module.getNumberOfLevels() - 1);
            return this.executeNodeMining();
        }
        return this.searchANodeToMine(currentLevel);
    }

    private IAIState searchANodeToMine(@NotNull MinerLevel currentLevel) {
        BlockPos standingPosition;
        Node parentNode;
        int vectorZ;
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (buildingMiner == null) {
            return AIWorkerState.IDLE;
        }
        MinerLevelManagementModule module = ((BuildingMiner)this.getOwnBuilding()).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (this.workingNode == null || this.workingNode.getStatus() == Node.NodeStatus.COMPLETED) {
            int levelId;
            this.workingNode = module.getActiveNode();
            module.setActiveNode(this.workingNode);
            if (this.workingNode == null && (levelId = module.getLevelId(currentLevel)) > 0) {
                module.setCurrentLevel(levelId - 1);
            }
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        int rotation = 0;
        int workingNodeX = this.workingNode.getX() > this.workingNode.getParent().getX() ? 1 : 0;
        int workingNodeZ = this.workingNode.getZ() > this.workingNode.getParent().getZ() ? 1 : 0;
        int vectorX = this.workingNode.getX() < this.workingNode.getParent().getX() ? -1 : workingNodeX;
        int n = vectorZ = this.workingNode.getZ() < this.workingNode.getParent().getZ() ? -1 : workingNodeZ;
        if (vectorX == -1) {
            rotation = 2;
        } else if (vectorZ == -1) {
            rotation = 3;
        } else if (vectorZ == 1) {
            rotation = 1;
        }
        if (this.workingNode.getRot().isPresent() && this.workingNode.getRot().get() != rotation) {
            Log.getLogger().warn("Calculated rotation doesn't match recorded: x:" + workingNodeX + " z:" + workingNodeZ);
        }
        if ((parentNode = currentLevel.getNode(this.workingNode.getParent())) != null && parentNode.getStyle() != Node.NodeType.SHAFT && parentNode.getStatus() != Node.NodeStatus.COMPLETED) {
            this.workingNode = parentNode;
            this.workingNode.setStatus(Node.NodeStatus.AVAILABLE);
            module.setActiveNode(parentNode);
            buildingMiner.markDirty();
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getParent().getX(), currentLevel.getDepth(), this.workingNode.getParent().getZ());
        if (this.workingNode != null && currentLevel.getNode(new Vec2i(this.workingNode.getX(), this.workingNode.getZ())) == null) {
            module.setActiveNode(null);
            module.setOldNode(null);
            return AIWorkerState.MINER_MINING_SHAFT;
        }
        if (!(this.workingNode.getStatus() != Node.NodeStatus.AVAILABLE && this.workingNode.getStatus() != Node.NodeStatus.IN_PROGRESS || this.walkToBlock(standingPosition))) {
            this.workingNode.setRot(rotation);
            return this.executeStructurePlacement(this.workingNode, standingPosition, rotation);
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private boolean secureBlock(@NotNull BlockPos curBlock, @NotNull BlockPos safeStand) {
        if (!this.getBlockState(curBlock).m_60767_().m_76334_() && this.getBlock(curBlock) != Blocks.f_50081_ || IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.m_8055_(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)this.getMainFillBlock()), 32, 1)) {
                return false;
            }
            this.setBlockFromInventory(curBlock, this.getMainFillBlock());
            return false;
        }
        return true;
    }

    private IAIState executeStructurePlacement(@NotNull Node mineNode, @NotNull BlockPos standingPosition, int rotation) {
        mineNode.setStatus(Node.NodeStatus.IN_PROGRESS);
        ((BuildingMiner)this.getOwnBuilding()).markDirty();
        if (((JobMiner)this.job).getBlueprint() == null) {
            BuildingMiner.initStructure(mineNode, rotation, new BlockPos(mineNode.getX(), ((BuildingMiner)this.getOwnBuilding()).getFirstModuleOccurance(MinerLevelManagementModule.class).getCurrentLevel().getDepth(), mineNode.getZ()), (BuildingMiner)this.getOwnBuilding(), this.world, (JobMiner)this.job);
            return AIWorkerState.LOAD_STRUCTURE;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -1; y <= 5; ++y) {
                    @NotNull BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.m_123342_() + y, mineNode.getZ() + z);
                    Block block = this.getBlock(curBlock);
                    if (!block.equals(Blocks.f_49990_) && !block.equals(Blocks.f_49991_)) continue;
                    this.setBlockFromInventory(curBlock, this.getMainFillBlock());
                }
            }
        }
        this.workingNode = null;
        if (((JobMiner)this.job).getBlueprint() != null) {
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.MINER_MINING_NODE;
    }

    @Override
    public IAIState afterStructureLoading() {
        return AIWorkerState.BUILDING_STEP;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, @NotNull Block block) {
        this.worker.m_6674_(this.worker.m_7655_());
        this.setBlockFromInventory(location, block, block.m_49966_());
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block, BlockState metadata) {
        int slot = block instanceof LadderBlock ? this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block) : this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block);
        if (slot != -1) {
            this.getInventory().extractItem(slot, 1, false);
            WorldUtil.setBlockState((LevelAccessor)this.world, location, metadata);
        }
    }

    private Block getBlock(@NotNull BlockPos loc) {
        return this.world.m_8055_(loc).m_60734_();
    }

    private int getFirstLadder(@NotNull BlockPos pos) {
        while (this.world.m_8055_(pos).isLadder((LevelReader)this.world, pos, (LivingEntity)this.worker)) {
            pos = pos.m_7494_();
        }
        return pos.m_123342_() - 1;
    }

    @Override
    public void executeSpecificCompleteActions() {
        BuildingMiner minerBuilding = (BuildingMiner)this.getOwnBuilding();
        MinerLevelManagementModule module = ((BuildingMiner)this.getOwnBuilding()).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (((JobMiner)this.job).getBlueprint() != null) {
            if (((JobMiner)this.job).getBlueprint().getName().contains("minermainshaft")) {
                int depth = ((JobMiner)this.job).getWorkOrder().getLocation().m_123342_();
                boolean exists = false;
                for (MinerLevel level : module.getLevels()) {
                    if (level.getDepth() != depth) continue;
                    exists = true;
                    break;
                }
                @Nullable BlockPos levelSignPos = WorkerUtil.findFirstLevelSign(((JobMiner)this.job).getBlueprint(), ((JobMiner)this.job).getWorkOrder().getLocation());
                @NotNull MinerLevel currentLevel = new MinerLevel(minerBuilding, ((JobMiner)this.job).getWorkOrder().getLocation().m_123342_(), levelSignPos);
                if (!exists) {
                    module.addLevel(currentLevel);
                    module.setCurrentLevel(module.getNumberOfLevels());
                }
                WorkerUtil.updateLevelSign(this.world, currentLevel, module.getLevelId(currentLevel));
            } else {
                MinerLevel currentLevel = module.getCurrentLevel();
                currentLevel.closeNextNode(((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getSettings().rotation.ordinal(), module.getActiveNode(), this.world);
                module.setActiveNode(null);
                module.setOldNode(this.workingNode);
                WorkerUtil.updateLevelSign(this.world, currentLevel, module.getLevelId(currentLevel));
            }
        }
        super.executeSpecificCompleteActions();
        ((BuildingMiner)this.getOwnBuilding()).markDirty();
        ((JobMiner)this.job).setBlueprint(null);
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getNodeMiningPosition(targetPosition);
    }

    private BlockPos getNodeMiningPosition(BlockPos blockToMine) {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        MinerLevelManagementModule module = buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (module.getCurrentLevel() == null || module.getActiveNode() == null) {
            return blockToMine;
        }
        Vec2i parentPos = module.getActiveNode().getParent();
        BlockPos vector = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_141950_((Vec3i)((BuildingMiner)this.getOwnBuilding()).getCobbleLocation());
        if (parentPos != null && module.getCurrentLevel().getNode(parentPos) != null && module.getCurrentLevel().getNode(parentPos).getStyle() == Node.NodeType.SHAFT) {
            BlockPos ladderPos = buildingMiner.getLadderLocation();
            return new BlockPos(ladderPos.m_123341_() + vector.m_123341_() * 6, module.getCurrentLevel().getDepth(), ladderPos.m_123343_() + vector.m_123343_() * 6);
        }
        Vec2i pos = module.getActiveNode().getParent();
        return new BlockPos(pos.getX(), module.getCurrentLevel().getDepth(), pos.getZ());
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    protected void triggerMinedBlock(@NotNull BlockState blockToMine) {
        super.triggerMinedBlock(blockToMine);
        double chance = 1.0 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MORE_ORES);
        if (IColonyManager.getInstance().getCompatibilityManager().isLuckyBlock(blockToMine.m_60734_())) {
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(IColonyManager.getInstance().getCompatibilityManager().getRandomLuckyOre(chance), (IItemHandler)this.worker.getInventoryCitizen());
        }
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((JobMiner)this.job).getWorkOrder() == null && ((JobMiner)this.job).getBlueprint() != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint() || ((JobMiner)this.job).getWorkOrder() != null && ((JobMiner)this.job).getWorkOrder().getStructureName().contains("quarry")) {
            ((JobMiner)this.job).setBlueprint(null);
            if (((JobMiner)this.job).hasWorkOrder()) {
                ((JobMiner)this.job).getColony().getWorkManager().removeWorkOrder(((JobMiner)this.job).getWorkOrderId());
            }
            ((JobMiner)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            ((BuildingMiner)this.getOwnBuilding()).cancelAllRequestsOfCitizen(this.worker.getCitizenData());
            ((BuildingMiner)this.getOwnBuilding()).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return true;
        }
        if (!this.isThereAStructureToBuild()) {
            switch ((AIWorkerState)this.getState()) {
                case BUILDING_STEP: {
                    return true;
                }
            }
            return false;
        }
        return ((JobMiner)this.job).getWorkOrder() != null && !WorldUtil.isBlockLoaded((LevelAccessor)this.world, ((JobMiner)this.job).getWorkOrder().getLocation()) && this.getState() != AIWorkerState.PICK_UP_RESIDUALS;
    }

    private boolean ladderDamaged() {
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123341_(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().m_123343_());
        return !this.world.m_8055_(nextLadder).isLadder((LevelReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.m_8055_(nextLadder).m_60815_();
    }
}

