/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.planter;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingPlantation;
import com.minecolonies.coremod.colony.jobs.JobPlanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPlanter
extends AbstractEntityAICrafting<JobPlanter, BuildingPlantation> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final Integer PLANT_TO_REQUEST = 16;
    private static final double XP_PER_HARVEST = 1.0;
    private BuildingPlantation.PlantationSoilPosition plantableSoilPos;

    public EntityAIWorkPlanter(@NotNull JobPlanter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.PLANTATION_MOVE_TO_SOIL, this::moveToSoil, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_CHECK_SOIL, this::checkSoil, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_CLEAR_OBSTACLE, this::clearObstacle, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_FARM, this::farm, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_PLANT, this::plant, 20));
        this.worker.m_21553_(true);
    }

    private IAIState plant() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_())) {
            return this.getState();
        }
        ItemStack currentStack = new ItemStack((ItemLike)this.plantableSoilPos.getCombination().getItem());
        int plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41656_(currentStack));
        if (plantInInv <= 0) {
            return AIWorkerState.START_WORKING;
        }
        if (this.world.m_46597_(this.plantableSoilPos.getPosition().m_7494_(), BlockUtils.getBlockStateFromStack((ItemStack)currentStack))) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), currentStack);
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState clearObstacle() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.isItemPositionAir(this.plantableSoilPos)) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_())) {
            return this.getState();
        }
        if (!this.holdEfficientTool(this.world.m_8055_(this.plantableSoilPos.getPosition().m_7494_()), this.plantableSoilPos.getPosition().m_7494_())) {
            return AIWorkerState.START_WORKING;
        }
        if (this.positionHasInvalidBlock(this.plantableSoilPos)) {
            this.mineBlock(this.plantableSoilPos.getPosition().m_7494_());
            return this.getState();
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState farm() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.isItemPositionAir(this.plantableSoilPos)) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_())) {
            return this.getState();
        }
        if (!this.holdEfficientTool(this.world.m_8055_(this.plantableSoilPos.getPosition().m_7494_()), this.plantableSoilPos.getPosition().m_7494_())) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.positionHasInvalidBlock(this.plantableSoilPos)) {
            this.mineBlock(this.plantableSoilPos.getPosition().m_7494_());
            return this.getState();
        }
        for (ItemEntity item : this.world.m_45976_(ItemEntity.class, new AABB(this.worker.m_142538_()).m_82363_(4.0, 1.0, 4.0).m_82363_(-4.0, -1.0, -4.0))) {
            if (item == null) continue;
            this.worker.getCitizenItemHandler().tryPickupItemEntity(item);
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.START_WORKING;
    }

    private IAIState checkSoil() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        BuildingPlantation plantation = (BuildingPlantation)this.getOwnBuilding();
        List<Item> availablePlants = plantation.getAvailablePlants();
        if (this.isItemPositionAir(this.plantableSoilPos)) {
            Item currentItem = this.plantableSoilPos.getCombination().getItem();
            int plantInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> itemStack.m_41656_(new ItemStack((ItemLike)currentItem)));
            int plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41656_(new ItemStack((ItemLike)currentItem)));
            if (!availablePlants.contains(currentItem)) {
                return AIWorkerState.START_WORKING;
            }
            if (plantInBuilding + plantInInv <= 0) {
                this.requestPlantable(currentItem);
                return AIWorkerState.START_WORKING;
            }
            return AIWorkerState.PLANTATION_PLANT;
        }
        if (this.positionHasInvalidBlock(this.plantableSoilPos)) {
            return AIWorkerState.PLANTATION_CLEAR_OBSTACLE;
        }
        if (this.isSufficientHeight(this.plantableSoilPos) || !availablePlants.contains(this.plantableSoilPos.getCombination().getItem())) {
            return AIWorkerState.PLANTATION_FARM;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState moveToSoil() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_(), 8)) {
            return this.getState();
        }
        return AIWorkerState.PLANTATION_CHECK_SOIL;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    public Class<BuildingPlantation> getExpectedBuildingClass() {
        return BuildingPlantation.class;
    }

    @Override
    protected IAIState decide() {
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING && nextState != AIWorkerState.IDLE) {
            return nextState;
        }
        BuildingPlantation plantation = (BuildingPlantation)this.getOwnBuilding();
        List<BuildingPlantation.PlantationSoilPosition> soilPositions = plantation.getAllSoilPositions();
        int soilPositionIndex = this.worker.m_21187_().nextInt(soilPositions.size());
        this.plantableSoilPos = soilPositions.get(soilPositionIndex);
        return AIWorkerState.PLANTATION_MOVE_TO_SOIL;
    }

    private void requestPlantable(Item current) {
        if (!((BuildingPlantation)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), q -> q.getRequest() instanceof Stack && ((Stack)q.getRequest()).getStack().m_41720_() == current)) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((ItemLike)current, PLANT_TO_REQUEST.intValue())));
        }
    }

    private boolean isItemPositionAir(BuildingPlantation.PlantationSoilPosition plantationSoilPosition) {
        Block foundBlock = this.world.m_8055_(plantationSoilPosition.getPosition().m_6630_(1)).m_60734_();
        return foundBlock instanceof AirBlock;
    }

    private boolean positionHasInvalidBlock(BuildingPlantation.PlantationSoilPosition plantationSoilPosition) {
        Block foundBlock = this.world.m_8055_(plantationSoilPosition.getPosition().m_6630_(1)).m_60734_();
        return plantationSoilPosition.getCombination().getBlock() != foundBlock;
    }

    private boolean isSufficientHeight(BuildingPlantation.PlantationSoilPosition plantationSoilPosition) {
        BlockPos position = plantationSoilPosition.getPosition();
        int minLength = plantationSoilPosition.getCombination().getMinimumLength();
        for (int i = 1; i <= minLength; ++i) {
            if (this.world.m_8055_(position.m_6630_(i)).m_60734_() == plantationSoilPosition.getCombination().getBlock()) continue;
            return false;
        }
        return true;
    }
}

