/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.VisitorData;
import com.minecolonies.coremod.colony.buildings.DefaultBuildingInstance;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.citizen.VisitorCitizen;
import com.minecolonies.coremod.util.NamedDamageSource;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class EntityAIVisitor
extends Goal {
    private static final int COMBAT_UPDATE_RATE = 20;
    private final VisitorCitizen citizen;
    private final ITickRateStateMachine<VisitorState> stateMachine;
    private DefaultBuildingInstance tavern;
    private int actionTimeoutCounter = 0;
    private Entity target = null;

    public EntityAIVisitor(@NotNull AbstractEntityCitizen entity) {
        this.citizen = (VisitorCitizen)entity;
        this.stateMachine = new TickRateStateMachine<VisitorState>(VisitorState.INIT, this::onException);
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.INIT, this::isEntityLoaded, () -> VisitorState.IDLE, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.IDLE, () -> true, this::decide, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.WANDERING, this::wander, () -> VisitorState.IDLE, 200));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.WANDERING, this::shouldFight, () -> VisitorState.COMBAT, 200));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.SITTING, this::sit, () -> VisitorState.IDLE, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.SITTING, this::shouldFight, () -> VisitorState.COMBAT, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.COMBAT, this::doFight, () -> VisitorState.IDLE, 20));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.IDLE, this::reduceTime, this.stateMachine::getState, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.WANDERING, this::reduceTime, this.stateMachine::getState, 50));
        this.stateMachine.addTransition(new TickingTransition<VisitorState>(VisitorState.SITTING, this::reduceTime, this.stateMachine::getState, 50));
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
    }

    private boolean reduceTime() {
        this.citizen.getCitizenData().decreaseSaturation(0.02);
        this.citizen.getCitizenData().markDirty();
        if (this.citizen.getCitizenData().getSaturation() <= 0.0) {
            this.citizen.getCitizenColonyHandler().getColony().getVisitorManager().removeCivilian(this.citizen.getCitizenData());
            if (this.tavern != null) {
                this.tavern.getFirstModuleOccurance(TavernBuildingModule.class).removeCitizen(this.citizen.getCivilianID());
            }
            return true;
        }
        return false;
    }

    private boolean doFight() {
        if (this.target == null || !this.target.m_6084_() || (this.actionTimeoutCounter -= 20) <= 0) {
            this.target = null;
            this.citizen.m_6703_(null);
            this.citizen.m_6710_(null);
            return true;
        }
        if (this.citizen.isWorkerAtSiteWithMove(new BlockPos(this.target.m_20182_()), 2) && this.citizen.m_142582_(this.target)) {
            this.citizen.m_6674_(InteractionHand.MAIN_HAND);
            this.target.m_6469_((DamageSource)new NamedDamageSource("death.attack.entity.minecolonies.visitor", (Entity)this.citizen), 10.0f);
        }
        return false;
    }

    private boolean wander() {
        if ((this.actionTimeoutCounter -= 50) <= 0) {
            return true;
        }
        this.citizen.getNavigation().moveToRandomPos(10.0, 0.6);
        return false;
    }

    private boolean shouldFight() {
        if (this.getTarget() != null) {
            this.actionTimeoutCounter = 600;
            return true;
        }
        return false;
    }

    private VisitorState decide() {
        if (this.shouldFight()) {
            return VisitorState.COMBAT;
        }
        int random = this.citizen.m_21187_().nextInt(5);
        if (this.tavern != null && (random == 0 || random == 1 && !this.citizen.getCitizenColonyHandler().getColony().isDay()) && this.tavern.hasModule(TavernBuildingModule.class)) {
            BlockPos pos = this.tavern.getFirstModuleOccurance(TavernBuildingModule.class).getFreeSitPosition();
            if (pos != null) {
                ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(pos);
                this.citizen.isWorkerAtSiteWithMove(pos, 1);
                this.actionTimeoutCounter = this.citizen.m_21187_().nextInt(2500) + 3000;
                return VisitorState.SITTING;
            }
        } else if (random == 2) {
            this.citizen.getNavigation().moveToRandomPos(10.0, 0.6);
            this.actionTimeoutCounter = this.citizen.getCitizenColonyHandler().getColony().isDay() ? this.citizen.m_21187_().nextInt(1000) + 1000 : 300;
            return VisitorState.WANDERING;
        }
        return VisitorState.IDLE;
    }

    private boolean sit() {
        if ((this.actionTimeoutCounter -= 50) <= 0) {
            ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(BlockPos.f_121853_);
            return true;
        }
        BlockPos moveTo = ((VisitorData)this.citizen.getCitizenData()).getSittingPosition();
        if (this.citizen.isWorkerAtSiteWithMove(moveTo, 1) && this.citizen.m_20202_() == null) {
            SittingEntity.sitDown(moveTo, (Mob)this.citizen, this.actionTimeoutCounter);
        }
        return false;
    }

    private boolean isEntityLoaded() {
        if (this.citizen.getCitizenColonyHandler().getColony() == null || this.citizen.getCitizenData() == null || this.citizen.getCitizenData().getHomeBuilding() == null) {
            return false;
        }
        IBuilding building = this.citizen.getCitizenData().getHomeBuilding();
        if (building.hasModule(TavernBuildingModule.class)) {
            this.tavern = (DefaultBuildingInstance)building;
        }
        ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(BlockPos.f_121853_);
        return WorldUtil.isEntityBlockLoaded((LevelAccessor)this.citizen.f_19853_, this.citizen.m_142538_());
    }

    private Entity getTarget() {
        if (this.target == null) {
            this.target = this.citizen.m_5448_();
            if (this.target == null) {
                this.target = this.citizen.m_142581_();
            }
        }
        return this.target;
    }

    private void onException(RuntimeException e) {
        Log.getLogger().warn("Visitor AI of:" + this.citizen.m_7755_() + " threw an Exception:", (Throwable)e);
    }

    public boolean m_8036_() {
        return true;
    }

    public boolean m_8045_() {
        this.stateMachine.tick();
        return true;
    }

    private void resetLogic() {
        ((VisitorData)this.citizen.getCitizenData()).setSittingPosition(BlockPos.f_121853_);
    }

    public void m_8041_() {
        this.stateMachine.reset();
        this.resetLogic();
    }

    public static enum VisitorState implements IState
    {
        INIT,
        IDLE,
        SLEEPING,
        SITTING,
        COMBAT,
        WANDERING;

    }
}

