/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenChatHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            if (job != null) {
                TranslatableComponent component = new TranslatableComponent("block.blockhuttownhall.messageworkerdead", new Object[]{new TranslatableComponent(job.getJobRegistryEntry().getTranslationKey()), this.citizen.getCitizenData().getName(), (int)this.citizen.m_20185_(), (int)this.citizen.m_20186_(), (int)this.citizen.m_20189_(), new TranslatableComponent(damageSource.f_19326_)});
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getImportantMessageEntityPlayers(), (String)"", (Object[])new Object[]{component});
            } else {
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getImportantMessageEntityPlayers(), (String)"", (Object[])new Object[]{new TranslatableComponent("block.blockhuttownhall.messagecolonistdead", new Object[]{this.citizen.getCitizenData().getName(), (int)this.citizen.m_20185_(), (int)this.citizen.m_20186_(), (int)this.citizen.m_20189_(), new TranslatableComponent(damageSource.f_19326_)})});
            }
        }
    }

    @Override
    public void sendLocalizedChat(String keyIn, Object ... msg) {
        String key = keyIn.toLowerCase(Locale.US);
        if (msg == null) {
            return;
        }
        TranslatableComponent requiredItem = msg.length == 0 ? new TranslatableComponent(key) : new TranslatableComponent(key, msg);
        this.sendLocalizedChat((Component)requiredItem);
    }

    @Override
    public void sendLocalizedChat(Component component) {
        TextComponent citizenDescription = new TextComponent(this.citizen.m_7770_().getString());
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            TextComponent colonyDescription = new TextComponent(" at " + this.citizen.getCitizenColonyHandler().getColony().getName() + ": ");
            ArrayList<Player> players = new ArrayList<Player>(this.citizen.getCitizenColonyHandler().getColony().getMessagePlayerEntities());
            Player owner = ServerUtils.getPlayerFromUUID(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.getCitizenColonyHandler().getColony().getPermissions().getOwner());
            if (owner != null) {
                players.remove(owner);
                LanguageHandler.sendPlayerMessage((Player)owner, (String)(this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getJobRegistryEntry().getTranslationKey()), (Object[])new Object[]{new TextComponent(" "), citizenDescription, component});
            }
            LanguageHandler.sendPlayersMessage(players, (String)(this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getJobRegistryEntry().getTranslationKey()), (Object[])new Object[]{new TextComponent(" "), citizenDescription, colonyDescription, component});
        }
    }
}

