/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class RaiderWalkAI
implements IStateAI {
    private final AbstractEntityMinecoloniesMob raider;
    private BlockPos targetBlock = null;
    private long nextCampfireTime = 0L;

    public RaiderWalkAI(AbstractEntityMinecoloniesMob raider, ITickRateStateMachine<IState> stateMachine) {
        this.raider = raider;
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.NO_TARGET, this::walk, () -> null, 80));
    }

    private boolean walk() {
        if (this.raider.getColony() != null) {
            IColonyEvent event = this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID());
            if (event == null) {
                return false;
            }
            if (event.getStatus() == EventStatus.PREPARING && event instanceof HordeRaidEvent) {
                this.walkToCampFire();
                return false;
            }
            if (this.targetBlock == null || this.raider.getNavigation().m_26571_() || this.targetBlock != null && this.raider.m_142538_().m_123331_((Vec3i)this.targetBlock) < 25.0) {
                this.targetBlock = this.raider.getColony().getRaiderManager().getRandomBuilding();
                BlockPos moveToPos = ShipBasedRaiderUtils.chooseWaypointFor(((IColonyRaidEvent)event).getWayPoints(), this.raider.m_142538_(), this.targetBlock);
                this.raider.getNavigation().moveToXYZ(moveToPos.m_123341_(), moveToPos.m_123342_(), moveToPos.m_123343_(), 1.1);
            }
        }
        return false;
    }

    private void walkToCampFire() {
        if (this.raider.f_19853_.m_46467_() - this.nextCampfireTime < 0L) {
            return;
        }
        BlockPos campFire = ((HordeRaidEvent)this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID())).getRandomCampfire();
        if (campFire == null) {
            return;
        }
        this.nextCampfireTime = this.raider.f_19853_.m_46467_() + (long)this.raider.f_19853_.f_46441_.nextInt(1000);
        this.targetBlock = BlockPosUtil.getRandomPosition(this.raider.f_19853_, campFire, BlockPos.f_121853_, 3, 6);
        if (this.targetBlock != null && this.targetBlock != BlockPos.f_121853_) {
            this.raider.getNavigation().moveToXYZ(this.targetBlock.m_123341_(), this.targetBlock.m_123342_(), this.targetBlock.m_123343_(), 1.0);
        }
    }
}

