/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.coremod.generation.CompostRecipeBuilder;
import com.minecolonies.coremod.recipes.FoodIngredient;
import com.minecolonies.coremod.recipes.PlantIngredient;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class DefaultRecipeProvider
extends RecipeProvider {
    public DefaultRecipeProvider(@NotNull DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @NotNull
    public String m_6055_() {
        return "DefaultVanillaRecipeProvider";
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.buildHutRecipes(consumer);
        this.buildOtherBlocks(consumer);
        this.buildOtherItems(consumer);
        this.buildFood(consumer, "", RecipeSerializer.f_44091_, 200);
        this.buildFood(consumer, "smoking", RecipeSerializer.f_44093_, 100);
        this.buildFood(consumer, "campfire_cooking", RecipeSerializer.f_44094_, 600);
        CompostRecipeBuilder.strength(2).input(new FoodIngredient.Builder().maxSaturation(0.5f).build()).input(Ingredient.m_204132_(ModTags.compostables_poor)).save(consumer, TagConstants.COMPOSTABLES_POOR);
        CompostRecipeBuilder.strength(4).input(new FoodIngredient.Builder().minSaturation(0.5f).maxSaturation(1.0f).build()).input(PlantIngredient.getInstance()).input(Ingredient.m_204132_(ModTags.compostables)).save(consumer, TagConstants.COMPOSTABLES);
        CompostRecipeBuilder.strength(8).input(new FoodIngredient.Builder().minSaturation(1.0f).build()).input(Ingredient.m_204132_(ModTags.compostables_rich)).save(consumer, TagConstants.COMPOSTABLES_RICH);
    }

    private void buildHutRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutArchery, (ItemLike)Items.f_42411_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBaker, (ItemLike)Items.f_42405_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBarracks, (ItemLike)Items.f_41913_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBeekeeper, (ItemLike)Items.f_42786_);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutBlacksmith, (ItemLike)Items.f_42416_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBuilder, (TagKey<Item>)ItemTags.f_13173_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutChickenHerder, (ItemLike)Items.f_42521_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutHome, (ItemLike)Items.f_42000_);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutCombatAcademy, (ItemLike)Items.f_42383_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutComposter, ModBlocks.blockBarrel);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutConcreteMixer, (ItemLike)Items.f_42315_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutCook, (ItemLike)Items.f_42410_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutCowboy, (ItemLike)Items.f_42579_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutDeliveryman, (ItemLike)Items.f_42463_);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutDeliveryman, (ItemLike)Items.f_42471_, "iron");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutDyer, (ItemLike)Items.f_42497_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutEnchanter, (ItemLike)Items.f_42100_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFarmer, (ItemLike)Items.f_42424_);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutFarmer, (ItemLike)Items.f_42429_, "stone");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFisherman, (ItemLike)Items.f_42523_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFletcher, (ItemLike)Items.f_42401_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFlorist, (ItemLike)Items.f_41940_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutGlassblower, (ItemLike)Items.f_41904_);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutGuardTower, (ItemLike)Items.f_42411_, "");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutHospital, (ItemLike)Items.f_42619_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutLibrary, (ItemLike)Items.f_42517_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutLumberjack, (ItemLike)Items.f_42423_);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutLumberjack, (ItemLike)Items.f_42428_, "stone");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutMechanic, (ItemLike)Items.f_42153_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutMiner, (ItemLike)Items.f_42422_);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutMiner, (ItemLike)Items.f_42427_, "stone");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutMysticalSite, (ItemLike)Items.f_42415_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutPlantation, (ItemLike)Items.f_41982_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutRabbitHutch, (ItemLike)Items.f_42697_);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutSawmill, (ItemLike)Items.f_42423_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutShepherd, (ItemLike)Items.f_42574_);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutSifter, (ItemLike)Items.f_42401_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutSmeltery, (ItemLike)Items.f_42416_);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutStonemason, (ItemLike)Items.f_42018_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutSwineHerder, (ItemLike)Items.f_42485_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutTavern, (ItemLike)Items.f_42768_);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutTownHall, (ItemLike)ModItems.buildTool.get());
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutWareHouse, (TagKey<Item>)Tags.Items.CHESTS);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockHutCrusher).m_126130_("XTX").m_126130_("CBC").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42594_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.f_42416_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockHutGraveyard).m_126130_("XTX").m_126130_("XBX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41905_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42500_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.f_42500_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockHutSchool).m_126130_("XTX").m_126130_("XBX").m_126130_("XBX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42402_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.f_42402_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockHutUniversity).m_126130_("XTX").m_126130_("XBX").m_126130_("XBX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.f_42517_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockHutStoneSmeltery).m_126130_("XTX").m_126130_("AFA").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42018_).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_41962_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.f_42018_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockScarecrow).m_126130_(" H ").m_126130_("SLS").m_126130_(" S ").m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('H'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42129_, Items.f_42046_})).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutFarmer})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockSimpleQuarry).m_126130_("XTX").m_126130_("XDX").m_126130_("XBX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42385_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42768_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutMiner})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockMediumQuarry).m_126130_("XTX").m_126130_("XDX").m_126130_("XBX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42390_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42768_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutMiner})).m_176498_(consumer);
    }

    private static InventoryChangeTrigger.TriggerInstance hasAllOf(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items);
    }

    private static InventoryChangeTrigger.TriggerInstance hasAllOf(ItemPredicate ... predicates) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])predicates);
    }

    private static ResourceLocation append(@NotNull ResourceLocation base, @NotNull String text1, @NotNull String text2) {
        if (text2.isEmpty()) {
            return base;
        }
        return new ResourceLocation("minecolonies", base.m_135815_() + text1 + text2);
    }

    private static ResourceLocation append(@NotNull ItemLike item, @NotNull String text) {
        return DefaultRecipeProvider.append(item.m_5456_().getRegistryName(), "", text);
    }

    private static void registerHutRecipe1(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ItemLike output, @NotNull ItemLike input) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_("XTX").m_126130_("XBX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get(), input)).m_176498_(consumer);
    }

    private static void registerHutRecipe1(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ItemLike output, @NotNull TagKey<Item> input) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_("XTX").m_126130_("XBX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('B'), input).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).m_45077_(), ItemPredicate.Builder.m_45068_().m_204145_(input).m_45077_())).m_176498_(consumer);
    }

    private static void registerHutRecipe1x2(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ItemLike output, @NotNull ItemLike input, @NotNull String name) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)2).m_126130_("XTX").m_126130_("XBX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get(), input)).m_142700_(consumer, DefaultRecipeProvider.append(output, name));
    }

    private static void registerHutRecipe3(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ItemLike output, @NotNull ItemLike input) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_("XTX").m_126130_("BBB").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get(), input)).m_176498_(consumer);
    }

    private void buildOtherBlocks(@NotNull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockBarrel).m_126130_("WTW").m_126130_("WGW").m_126130_("WSW").m_206416_(Character.valueOf('W'), ItemTags.f_13168_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.f_42416_})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockCompostedDirt).m_126130_("XXX").m_126130_("XPX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('P'), (ItemLike)com.minecolonies.api.items.ModItems.compost).m_142284_("has_compost", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.compost)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockConstructionTape).m_126130_("SWS").m_126130_("S S").m_126130_("S S").m_206416_(Character.valueOf('W'), ItemTags.f_13167_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_142284_("has_wool", (CriterionTriggerInstance)DefaultRecipeProvider.m_206406_((TagKey)ItemTags.f_13167_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockPostBox).m_126130_("XSX").m_126130_("III").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.CHESTS).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).m_45077_(), ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.CHESTS).m_45077_())).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockStash).m_126130_("XSX").m_126130_("IXI").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.CHESTS).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).m_45077_(), ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.CHESTS).m_45077_())).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_(ModBlocks.blockRack).m_126130_("XXX").m_126130_("ISI").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_build_tool", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.buildTool.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_(ModBlocks.blockWayPoint, (int)16).m_126130_("XXX").m_126130_("XBX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_build_tool", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.buildTool.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42211_).m_126209_((ItemLike)Items.f_41865_).m_126209_((ItemLike)Items.f_41865_).m_142284_("has_fern", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_41865_)).m_142700_(consumer, new ResourceLocation("minecolonies", "doublefern"));
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42210_).m_126209_((ItemLike)Items.f_41864_).m_126209_((ItemLike)Items.f_41864_).m_142284_("has_grass", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_41864_)).m_142700_(consumer, new ResourceLocation("minecolonies", "doublegrass"));
    }

    private void buildFood(@NotNull Consumer<FinishedRecipe> consumer, @NotNull String method, @NotNull SimpleCookingSerializer<?> serializer, int cookingTime) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.breadDough}), (ItemLike)Items.f_42406_, (float)0.35f, (int)cookingTime, serializer).m_142284_("has_dough", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.breadDough)).m_142700_(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_bread"), "_", method));
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cakeBatter}), (ItemLike)Items.f_42502_, (float)0.35f, (int)cookingTime, serializer).m_142284_("has_dough", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.cakeBatter)).m_142700_(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cake"), "_", method));
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cookieDough}), (ItemLike)Items.f_42572_, (float)0.0475f, (int)(cookingTime / 8), serializer).m_142284_("has_dough", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.cookieDough)).m_142700_(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cookies"), "_", method));
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.rawPumpkinPie}), (ItemLike)Items.f_42687_, (float)0.35f, (int)cookingTime, serializer).m_142284_("has_dough", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.rawPumpkinPie)).m_142700_(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_pumpkin_pie"), "_", method));
    }

    private void buildOtherItems(@NotNull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)com.minecolonies.api.items.ModItems.flagBanner).m_126130_(" W ").m_126130_(" W ").m_126130_(" B ").m_206416_(Character.valueOf('W'), ItemTags.f_13167_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).m_45077_(), ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_13167_).m_45077_())).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)com.minecolonies.api.items.ModItems.bannerRallyGuards).m_126130_("AAA").m_126130_("BXB").m_126130_("CCC").m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42383_).m_126127_(Character.valueOf('B'), ModBlocks.blockHutGuardTower).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42664_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42411_).m_142284_("has_items", (CriterionTriggerInstance)DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutGuardTower})).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42464_).m_126130_("NNN").m_126130_("NIN").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_142284_("has_iron", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_142700_(consumer, new ResourceLocation("minecolonies", "chainmailhelmet"));
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42465_).m_126130_("I I").m_126130_("NNN").m_126130_("NNN").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_142284_("has_iron", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_142700_(consumer, new ResourceLocation("minecolonies", "chainmailchestplate"));
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42466_).m_126130_("III").m_126130_("N N").m_126130_("N N").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_142284_("has_iron", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_142700_(consumer, new ResourceLocation("minecolonies", "chainmailleggings"));
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42467_).m_126130_("I I").m_126130_("N N").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_142284_("has_iron", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_142700_(consumer, new ResourceLocation("minecolonies", "chainmailboots"));
        ShapedRecipeBuilder.m_126116_((ItemLike)com.minecolonies.api.items.ModItems.clipboard).m_126130_("XTX").m_126130_("XPX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42454_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_build_tool", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.buildTool.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)com.minecolonies.api.items.ModItems.resourceScroll).m_126130_("XTX").m_126130_("XPX").m_126130_("XPX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42454_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).m_142284_("has_build_tool", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.buildTool.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ModItems.shapeTool.get())).m_126130_("  X").m_126130_(" S ").m_126130_("S  ").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_142284_("has_stick", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)Items.f_42398_)).m_142700_(consumer, new ResourceLocation("minecolonies", "shapetool"));
        ShapedRecipeBuilder.m_126116_((ItemLike)com.minecolonies.api.items.ModItems.supplyCamp).m_126130_("   ").m_126130_("C C").m_126130_("CCC").m_206416_(Character.valueOf('C'), Tags.Items.CHESTS).m_142284_("has_chest", (CriterionTriggerInstance)DefaultRecipeProvider.m_206406_((TagKey)Tags.Items.CHESTS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)com.minecolonies.api.items.ModItems.supplyChest).m_126130_("   ").m_126130_("B B").m_126130_("BBB").m_206416_(Character.valueOf('B'), ItemTags.f_13155_).m_142284_("has_boat", (CriterionTriggerInstance)DefaultRecipeProvider.m_206406_((TagKey)ItemTags.f_13155_)).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.scimitar}), (ItemLike)Items.f_42749_, (float)0.1f, (int)200).m_142284_("has_scimitar", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.scimitar)).m_142700_(consumer, new ResourceLocation("minecolonies", "iron_nugget_from_iron_scimitar_smelting"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.scimitar}), (ItemLike)Items.f_42749_, (float)0.1f, (int)100).m_142284_("has_scimitar", (CriterionTriggerInstance)DefaultRecipeProvider.m_125977_((ItemLike)com.minecolonies.api.items.ModItems.scimitar)).m_142700_(consumer, new ResourceLocation("minecolonies", "iron_nugget_from_iron_scimitar_blasting"));
    }
}

