/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyCampDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_CAMP_STRUCTURE_NAME = "supplycamp";
    private static final int OFFSET_DISTANCE = 5;
    private static final int OFFSET_LEFT = 0;
    private static final int OFFSET_Y = 0;

    public ItemSupplyCampDeployer(Item.Properties properties) {
        super("supplycampdeployer", properties.m_41487_(1).m_41491_(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.m_43725_())) {
                LanguageHandler.sendPlayerMessage((Player)ctx.m_43723_(), (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
                return InteractionResult.FAIL;
            }
            this.placeSupplyCamp(ctx.m_8083_().m_142300_(ctx.m_43719_()), ctx.m_43723_().m_6350_());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (worldIn.f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                LanguageHandler.sendPlayerMessage((Player)playerIn, (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            this.placeSupplyCamp(null, playerIn.m_6350_());
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void placeSupplyCamp(@Nullable BlockPos pos, @NotNull Direction direction) {
        BlockPos tempPos;
        if (pos == null) {
            MineColonies.proxy.openBuildToolWindow(null, SUPPLY_CAMP_STRUCTURE_NAME, 0, 2);
            return;
        }
        MineColonies.proxy.openBuildToolWindow(tempPos, SUPPLY_CAMP_STRUCTURE_NAME, switch (direction) {
            case Direction.SOUTH -> {
                tempPos = pos.m_142082_(0, 0, 5);
                yield 3;
            }
            case Direction.NORTH -> {
                tempPos = pos.m_142082_(0, 0, -5);
                yield 1;
            }
            case Direction.EAST -> {
                tempPos = pos.m_142082_(5, 0, 0);
                yield 2;
            }
            default -> {
                tempPos = pos.m_142082_(-5, 0, 0);
                yield 0;
            }
        }, 2);
    }

    public static boolean canCampBePlaced(@NotNull Level world, @NotNull BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        if (((Boolean)MineColonies.getConfig().getServer().noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        BlockPos zeroPos = pos.m_141950_((Vec3i)Settings.instance.getActiveStructure().getPrimaryBlockOffset());
        short sizeX = Settings.instance.getActiveStructure().getSizeX();
        short sizeZ = Settings.instance.getActiveStructure().getSizeZ();
        int groundLevel = zeroPos.m_123342_() + BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)Settings.instance.getActiveStructure(), (int)1) - 1;
        for (int z = zeroPos.m_123343_(); z < zeroPos.m_123343_() + sizeZ; ++z) {
            for (int x = zeroPos.m_123341_(); x < zeroPos.m_123341_() + sizeX; ++x) {
                ItemSupplyCampDeployer.checkIfSolidAndNotInColony(world, new BlockPos(x, groundLevel, z), placementErrorList, placer);
                if (!world.m_8055_(new BlockPos(x, groundLevel + 1, z)).m_60767_().m_76333_()) continue;
                PlacementError placementError = new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, new BlockPos(x, pos.m_123342_(), z));
                placementErrorList.add(placementError);
            }
        }
        return placementErrorList.isEmpty();
    }

    private static void checkIfSolidAndNotInColony(Level world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        PlacementError placementError;
        boolean isSolid = world.m_8055_(pos).m_60767_().m_76333_();
        boolean notInAnyColony = ItemSupplyCampDeployer.hasPlacePermission(world, pos, placer);
        if (!isSolid) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_SOLID, pos);
            placementErrorList.add(placementError);
        }
        if (!notInAnyColony) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos);
            placementErrorList.add(placementError);
        }
    }

    private static boolean hasPlacePermission(Level world, BlockPos pos, Player placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

