/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalizedParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private ItemStack stack;
    private double posX;
    private double posY;
    private double posZ;

    public LocalizedParticleEffectMessage() {
    }

    public LocalizedParticleEffectMessage(ItemStack stack, BlockPos pos) {
        this.stack = stack;
        this.posX = (double)pos.m_123341_() + 0.5;
        this.posY = (double)pos.m_123342_() + 0.5;
        this.posZ = (double)pos.m_123343_() + 0.5;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        ItemStack localStack = this.stack;
        for (int i = 0; i < 5; ++i) {
            Vec3 randomPos = new Vec3((RAND.nextDouble() - 0.5) * 0.1, RAND.nextDouble() * 0.1 + 0.1, 0.0);
            Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.1, RAND.nextDouble() - 0.05, (RAND.nextDouble() - 0.5) * 0.1);
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, localStack), this.posX + randomOffset.f_82479_, this.posY + randomOffset.f_82480_, this.posZ + randomOffset.f_82481_, randomPos.f_82479_, randomPos.f_82480_ + 0.05, randomPos.f_82481_);
        }
    }
}

