/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildToolPlaceMessage
implements IMessage {
    private BlockState state;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;
    public BlockPos builder = BlockPos.f_121853_;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, BlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.state = state;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.structureName = buf.m_130136_(Short.MAX_VALUE);
        this.workOrderName = buf.m_130136_(Short.MAX_VALUE);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.state = Block.m_49803_((int)buf.readInt());
        this.builder = buf.m_130135_();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130070_(this.structureName);
        buf.m_130070_(this.workOrderName);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeInt(Block.m_49956_((BlockState)this.state));
        buf.m_130064_(this.builder);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        StructureName sn = new StructureName(this.structureName);
        if (!Structures.hasMD5((StructureName)sn)) {
            player.m_6352_((Component)new TextComponent("Can not build " + this.workOrderName + ": schematic missing!"), player.m_142081_());
            return;
        }
        if (this.isHut) {
            BuildToolPlaceMessage.handleHut(CompatibilityUtils.getWorldFromEntity((Entity)player), (Player)player, sn, this.rotation, this.pos, this.mirror, this.state);
        } else {
            BuildToolPlaceMessage.handleDecoration(CompatibilityUtils.getWorldFromEntity((Entity)player), (Player)player, sn, this.workOrderName, this.rotation, this.pos, this.mirror, this.builder);
        }
    }

    private static void handleHut(@NotNull Level world, @NotNull Player player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockState state) {
        BlockState stateAtPos = world.m_8055_(buildPos);
        Block blockAtPos = stateAtPos.m_60734_();
        if (blockAtPos instanceof IBuilderUndestroyable || stateAtPos.m_204336_(ModTags.indestructible)) {
            LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.buildtool.indestructible", (Object[])new Object[0]);
            SoundUtils.playErrorSound(player, buildPos);
            return;
        }
        Block block = state.m_60734_();
        ItemStack tempStack = new ItemStack((ItemLike)block, 1);
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, s, false, false));
        if (slot < 0) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(slot);
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, buildPos);
        if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) || block instanceof BlockHutTownHall && IColonyManager.getInstance().isFarEnoughFromColonies(world, buildPos))) {
            return;
        }
        CompoundTag compound = stack.m_41783_();
        if (tempColony != null && compound != null && compound.m_128441_("colony") && tempColony.getID() != compound.m_128451_("colony")) {
            LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.gui.buildtool.wrongcolony", (Object[])new Object[]{compound.m_128451_("colony")});
            return;
        }
        if (block != null && player.m_150109_().m_36063_(new ItemStack((ItemLike)block))) {
            if (EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
                if (tempColony != null) {
                    AdvancementUtils.TriggerAdvancementPlayersForColony(tempColony, playerMP -> AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayer)playerMP, sn));
                } else {
                    AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayer)player, sn);
                }
                world.m_46961_(buildPos, true);
                world.m_46597_(buildPos, state);
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.m_8055_(buildPos), (LivingEntity)player, null, mirror, sn.getStyle());
                boolean complete = false;
                int level = 0;
                if (compound != null) {
                    if (compound.m_128431_().contains("otherLevel")) {
                        level = compound.m_128451_("otherLevel");
                    }
                    if (compound.m_128431_().contains("isPasteable")) {
                        Object schematic = sn.toString();
                        schematic = ((String)schematic).substring(0, ((String)schematic).length() - 1);
                        schematic = (String)schematic + level;
                        CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.f_19853_, (String)schematic, buildPos, BlockPosUtil.getRotationFromRotations(rotation), mirror ? Mirror.FRONT_BACK : Mirror.NONE, true, (ServerPlayer)player);
                        complete = true;
                    }
                }
                InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack, 1);
                BuildToolPlaceMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror, level, complete);
            }
        } else {
            LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.gui.buildtool.nohutininventory", (Object[])new Object[0]);
        }
    }

    private static void handleDecoration(@NotNull Level world, @NotNull Player player, StructureName sn, String workOrderName, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockPos builder) {
        @Nullable IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            Object schem = sn.toString();
            Object woName = workOrderName;
            if (!((String)schem).contains("cache")) {
                if (((String)schem).matches("^.*[a-zA-Z_-]\\d$")) {
                    schem = ((String)schem).replaceAll("\\d$", "");
                    schem = (String)schem + "1";
                }
                if (((String)woName).matches("^.*[a-zA-Z_-]\\d$")) {
                    woName = ((String)woName).replaceAll("\\d$", "");
                    woName = (String)woName + "1";
                }
            }
            WorkOrderDecoration woDeco = WorkOrderDecoration.create(WorkOrderType.BUILD, (String)schem, WordUtils.capitalizeFully((String)woName), buildPos, rotation, mirror, 0);
            if (!builder.equals((Object)BlockPos.f_121853_)) {
                woDeco.setClaimedBy(builder);
            }
            colony.getWorkManager().addWorkOrder(woDeco, false);
        } else {
            SoundUtils.playErrorSound(player, player.m_142538_());
            Log.getLogger().error("handleDecoration: Could not build " + sn, (Throwable)new Exception());
        }
    }

    private static void setupBuilding(@NotNull Level world, @NotNull Player player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, int level, boolean complete) {
        @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, buildPos);
        if (building == null) {
            if (!sn.getHutName().equals("townhall")) {
                SoundUtils.playErrorSound(player, player.m_142538_());
                Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
            }
        } else {
            SoundUtils.playSuccessSound(player, player.m_142538_());
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.m_7755_().getString());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            building.setStyle(sn.getStyle());
            building.setBuildingLevel(level);
            if (level > 0) {
                building.setDeconstructed();
            }
            if (!(building instanceof IRSComponent)) {
                ConstructionTapeHelper.placeConstructionTape(building.getCorners(), world);
            }
            building.setIsMirrored(mirror);
            if (complete) {
                building.onUpgradeComplete(building.getBuildingLevel());
            }
        }
    }
}

