/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorationBuildRequestMessage
implements IMessage {
    private BlockPos pos;
    private String displayName;
    private String name;
    private int level;
    private ResourceKey<Level> dimension;

    public DecorationBuildRequestMessage() {
    }

    public DecorationBuildRequestMessage(@NotNull BlockPos pos, String displayName, String name, int level, ResourceKey<Level> dimension) {
        this.pos = pos;
        this.displayName = displayName;
        this.name = name;
        this.level = level;
        this.dimension = dimension;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.displayName = buf.m_130136_(Short.MAX_VALUE);
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.level = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.displayName);
        buf.m_130070_(this.name);
        buf.writeInt(this.level);
        buf.m_130070_(this.dimension.m_135782_().toString());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromDim(this.dimension, this.pos);
        if (colony == null) {
            return;
        }
        ServerPlayer player = ctxIn.getSender();
        if (!colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            return;
        }
        BlockEntity entity = player.m_20193_().m_7702_(this.pos);
        if (entity instanceof TileEntityDecorationController) {
            BlockState structureState;
            Optional<Map.Entry> wo = colony.getWorkManager().getWorkOrders().entrySet().stream().filter(entry -> entry.getValue() instanceof WorkOrderDecoration).filter(entry -> ((IWorkOrder)entry.getValue()).getLocation().equals((Object)this.pos)).findFirst();
            if (wo.isPresent()) {
                colony.getWorkManager().removeWorkOrder((Integer)wo.get().getKey());
                return;
            }
            int difference = 0;
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(colony.getWorld(), this.pos, this.name + this.level, new PlacementSettings(), true);
            Blueprint blueprint = structure.getBluePrint();
            if (blueprint != null && (structureState = ((BlockInfo)structure.getBluePrint().getBlockInfoAsMap().get(structure.getBluePrint().getPrimaryBlockOffset())).getState()) != null) {
                int worldRotation;
                if (!(structureState.m_60734_() instanceof BlockDecorationController)) {
                    Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", this.name + this.level));
                    return;
                }
                int structureRotation = ((Direction)structureState.m_61143_((Property)BlockDecorationController.f_54117_)).m_122416_();
                difference = structureRotation <= (worldRotation = ((Direction)colony.getWorld().m_8055_(this.pos).m_61143_((Property)BlockDecorationController.f_54117_)).m_122416_()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
            }
            BlockState state = player.m_20193_().m_8055_(this.pos);
            int currentLevel = ((TileEntityDecorationController)entity).getTier();
            WorkOrderDecoration order = this.level > currentLevel ? WorkOrderDecoration.create(WorkOrderType.UPGRADE, this.name + this.level, WordUtils.capitalizeFully((String)this.displayName), this.pos, difference, (Boolean)state.m_61143_((Property)BlockDecorationController.MIRROR), currentLevel) : (this.level == currentLevel ? WorkOrderDecoration.create(WorkOrderType.REPAIR, this.name + this.level, WordUtils.capitalizeFully((String)this.displayName), this.pos, difference, (Boolean)state.m_61143_((Property)BlockDecorationController.MIRROR), currentLevel) : WorkOrderDecoration.create(WorkOrderType.BUILD, this.name + this.level, WordUtils.capitalizeFully((String)this.displayName), this.pos, difference, (Boolean)state.m_61143_((Property)BlockDecorationController.MIRROR), currentLevel));
            colony.getWorkManager().addWorkOrder(order, false);
        }
    }
}

