/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleBannerRallyGuardsMessage
implements IMessage {
    private ItemStack banner;

    public ToggleBannerRallyGuardsMessage() {
    }

    public ToggleBannerRallyGuardsMessage(ItemStack banner) {
        this.banner = banner;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.banner = buf.m_130267_();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.banner);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, this.banner));
        if (slot == -1) {
            LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.item.bannerrallyguards.gui.error", (Object[])new Object[0]);
            return;
        }
        ItemBannerRallyGuards.toggleBanner(player.m_150109_().m_8020_(slot), (Player)player);
    }
}

