/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.citizen;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AdjustSkillCitizenMessage
extends AbstractColonyServerMessage {
    private int citizenId;
    private int quantity;
    private Skill skill;

    public AdjustSkillCitizenMessage() {
    }

    public AdjustSkillCitizenMessage(IColony colony, @NotNull ICitizenDataView citizenDataView, int quantity, Skill skill) {
        super(colony);
        this.citizenId = citizenDataView.getId();
        this.quantity = quantity;
        this.skill = skill;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.citizenId = buf.readInt();
        this.quantity = buf.readInt();
        this.skill = Skill.values()[buf.readInt()];
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.citizenId);
        buf.writeInt(this.quantity);
        buf.writeInt(this.skill.ordinal());
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            Log.getLogger().warn("AdjustSkillCitizenMessage citizenData is null");
            return;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            Log.getLogger().warn("AdjustSkillCitizenMessage entity citizen is null");
            return;
        }
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        boolean isCreative = player.m_7500_();
        if (!isCreative) {
            Log.getLogger().warn("AdjustSkillCitizenMessage player must be creative.");
            return;
        }
        citizenData.getCitizenSkillHandler().incrementLevel(this.skill, this.quantity);
        citizenData.markDirty();
    }
}

