/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.interactionhandling.registry.InteractionResponseHandlerEntry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.CountedIngredient;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import com.minecolonies.apiimp.CommonMinecoloniesAPIImpl;
import com.minecolonies.apiimp.initializer.ModBuildingsInitializer;
import com.minecolonies.apiimp.initializer.ModColonyEventDescriptionTypeInitializer;
import com.minecolonies.apiimp.initializer.ModColonyEventTypeInitializer;
import com.minecolonies.apiimp.initializer.ModGuardTypesInitializer;
import com.minecolonies.apiimp.initializer.ModInteractionsInitializer;
import com.minecolonies.apiimp.initializer.ModJobsInitializer;
import com.minecolonies.apiimp.initializer.ModRecipeTypesInitializer;
import com.minecolonies.apiimp.initializer.ModResearchEffectInitializer;
import com.minecolonies.apiimp.initializer.ModResearchRequirementInitializer;
import com.minecolonies.coremod.proxy.IProxy;
import com.minecolonies.coremod.recipes.FoodIngredient;
import com.minecolonies.coremod.recipes.PlantIngredient;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.MOD)
public abstract class CommonProxy
implements IProxy {
    protected static CommonMinecoloniesAPIImpl apiImpl;
    private static final Map<String, CompoundTag> playerPropertiesData;
    public static RecipeSerializer<?> SPECIAL_REC;

    public CommonProxy() {
        apiImpl = new CommonMinecoloniesAPIImpl();
    }

    public static void storeEntityData(String name, CompoundTag compound) {
        playerPropertiesData.put(name, compound);
    }

    public static CompoundTag getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerGuardTypes(RegistryEvent.Register<GuardType> event) {
        ModGuardTypesInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerNewRegistries(NewRegistryEvent event) {
        apiImpl.onRegistryNewRegistry(event);
    }

    @Override
    public void setupApi() {
        MinecoloniesAPIProxy.getInstance().setApiInstance(apiImpl);
    }

    @SubscribeEvent
    public static void registerBuildingTypes(@NotNull RegistryEvent.Register<BuildingEntry> event) {
        ModBuildingsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerResearchRequirementTypes(@NotNull RegistryEvent.Register<ResearchRequirementEntry> event) {
        ModResearchRequirementInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerResearchEffectTypes(@NotNull RegistryEvent.Register<ResearchEffectEntry> event) {
        ModResearchEffectInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerInteractionTypes(@NotNull RegistryEvent.Register<InteractionResponseHandlerEntry> event) {
        ModInteractionsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerColonyEventTypes(@NotNull RegistryEvent.Register<ColonyEventTypeRegistryEntry> event) {
        ModColonyEventTypeInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerColonyEventDescriptionTypes(@NotNull RegistryEvent.Register<ColonyEventDescriptionTypeRegistryEntry> event) {
        ModColonyEventDescriptionTypeInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerJobTypes(RegistryEvent.Register<JobEntry> event) {
        ModJobsInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerRecipeTypes(RegistryEvent.Register<RecipeTypeEntry> event) {
        ModRecipeTypesInitializer.init(event);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)((RecipeSerializer)CompostRecipe.Serializer.getInstance().setRegistryName(CompostRecipe.ID)));
        CraftingHelper.register((ResourceLocation)CountedIngredient.ID, (IIngredientSerializer)CountedIngredient.Serializer.getInstance());
        CraftingHelper.register((ResourceLocation)FoodIngredient.ID, (IIngredientSerializer)FoodIngredient.Serializer.getInstance());
        CraftingHelper.register((ResourceLocation)PlantIngredient.ID, (IIngredientSerializer)PlantIngredient.Serializer.getInstance());
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void showCitizenWindow(ICitizenDataView citizen) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void openShapeToolWindow(BlockPos pos) {
    }

    @Override
    public void openSuggestionWindow(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation, int groundstyle) {
    }

    @Override
    public void openBannerRallyGuardsWindow(ItemStack banner) {
    }

    @Override
    public void openClipboardWindow(IColonyView colonyView) {
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos pos) {
    }

    @Override
    public File getSchematicsFolder() {
        return null;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull Player player) {
        return ((ServerPlayer)player).m_8952_();
    }

    @Override
    public void openDecorationControllerWindow(@NotNull BlockPos pos) {
    }

    static {
        playerPropertiesData = new HashMap<String, CompoundTag>();
    }
}

