/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.ResearchBranchType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class GlobalResearchBranch
implements IGlobalResearchBranch {
    public static final String RESEARCH_BRANCH_NAME_PROP = "branch-name";
    private static final String RESEARCH_SUBTITLE_PROP = "subtitle";
    public static final String RESEARCH_BRANCH_TYPE_PROP = "branch-type";
    public static final String RESEARCH_BASE_TIME_PROP = "base-time";
    private static final String RESEARCH_HIDDEN_PROP = "hidden";
    private static final String RESEARCH_SORT_PROP = "sortOrder";
    private final TranslatableComponent name;
    private final TranslatableComponent subtitle;
    private final ResearchBranchType type;
    private final double baseTime;
    private final int sortOrder;
    private final boolean hidden;

    @Override
    public TranslatableComponent getName() {
        return this.name;
    }

    @Override
    public TranslatableComponent getSubtitle() {
        return this.subtitle;
    }

    @Override
    public int getBaseTime(int depth) {
        return (int)(144.0 * this.baseTime * Math.pow(2.0, depth - 1));
    }

    @Override
    public double getHoursTime(int depth) {
        return 144.0 * this.baseTime * Math.pow(2.0, depth - 1) / 288.0;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public ResearchBranchType getType() {
        return this.type;
    }

    @Override
    public boolean getHidden() {
        return this.hidden;
    }

    public GlobalResearchBranch(ResourceLocation id) {
        this.name = id.m_135815_().isEmpty() ? new TranslatableComponent("") : new TranslatableComponent(id.m_135815_().substring(0, 1).toUpperCase() + id.m_135815_().substring(1));
        this.subtitle = new TranslatableComponent("");
        this.baseTime = 1.0;
        this.type = ResearchBranchType.DEFAULT;
        this.hidden = false;
        this.sortOrder = 1000;
    }

    public GlobalResearchBranch(ResourceLocation id, JsonObject researchJson) {
        this.name = researchJson.has(RESEARCH_BRANCH_NAME_PROP) && researchJson.get(RESEARCH_BRANCH_NAME_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_NAME_PROP).getAsJsonPrimitive().isString() ? new TranslatableComponent(researchJson.get(RESEARCH_BRANCH_NAME_PROP).getAsJsonPrimitive().getAsString()) : (id.m_135815_().isEmpty() ? new TranslatableComponent("") : new TranslatableComponent(id.m_135815_().substring(0, 1).toUpperCase() + id.m_135815_().substring(1)));
        this.subtitle = researchJson.has(RESEARCH_SUBTITLE_PROP) && researchJson.get(RESEARCH_SUBTITLE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SUBTITLE_PROP).getAsJsonPrimitive().isString() ? new TranslatableComponent(researchJson.get(RESEARCH_SUBTITLE_PROP).getAsJsonPrimitive().getAsString()) : new TranslatableComponent("");
        this.baseTime = researchJson.has(RESEARCH_BASE_TIME_PROP) && researchJson.get(RESEARCH_BASE_TIME_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BASE_TIME_PROP).getAsJsonPrimitive().isNumber() ? researchJson.get(RESEARCH_BASE_TIME_PROP).getAsJsonPrimitive().getAsDouble() : 1.0;
        this.sortOrder = researchJson.has(RESEARCH_SORT_PROP) && researchJson.get(RESEARCH_SORT_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().isNumber() ? researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().getAsInt() : 1000;
        this.type = researchJson.has(RESEARCH_BRANCH_TYPE_PROP) && researchJson.get(RESEARCH_BRANCH_TYPE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_TYPE_PROP).getAsJsonPrimitive().isString() ? ResearchBranchType.valueOfTag(researchJson.get(RESEARCH_BRANCH_TYPE_PROP).getAsJsonPrimitive().getAsString()) : ResearchBranchType.DEFAULT;
        this.hidden = researchJson.has(RESEARCH_HIDDEN_PROP) && researchJson.get(RESEARCH_HIDDEN_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_HIDDEN_PROP).getAsJsonPrimitive().isBoolean() ? researchJson.get(RESEARCH_HIDDEN_PROP).getAsJsonPrimitive().getAsBoolean() : false;
    }

    public GlobalResearchBranch(CompoundTag nbt) {
        this.name = new TranslatableComponent(nbt.m_128461_(RESEARCH_BRANCH_NAME_PROP));
        this.subtitle = new TranslatableComponent(nbt.m_128461_(RESEARCH_SUBTITLE_PROP));
        this.type = ResearchBranchType.valueOfTag(nbt.m_128461_(RESEARCH_BRANCH_TYPE_PROP));
        this.baseTime = nbt.m_128459_(RESEARCH_BASE_TIME_PROP);
        this.sortOrder = nbt.m_128451_(RESEARCH_SORT_PROP);
        this.hidden = nbt.m_128471_(RESEARCH_HIDDEN_PROP);
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(RESEARCH_BRANCH_NAME_PROP, this.name.m_131328_());
        nbt.m_128359_(RESEARCH_SUBTITLE_PROP, this.subtitle.m_131328_());
        nbt.m_128359_(RESEARCH_BRANCH_TYPE_PROP, this.type.tag);
        nbt.m_128347_(RESEARCH_BASE_TIME_PROP, this.baseTime);
        nbt.m_128405_(RESEARCH_SORT_PROP, this.sortOrder);
        nbt.m_128379_(RESEARCH_HIDDEN_PROP, this.hidden);
        return nbt;
    }
}

