/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ResearchEffectCategory {
    public static final String RESEARCH_EFFECT_PROP = "effect";
    public static final String RESEARCH_EFFECT_LEVELS_PROP = "levels";
    private final ResourceLocation effectId;
    private final TranslatableComponent effectName;
    private final TranslatableComponent subtitle;
    private final List<Double> levelsAbsolute = new ArrayList<Double>();
    private final List<Double> levelsRelative = new ArrayList<Double>();

    public ResearchEffectCategory(String effectId, String effectName, String subtitle) {
        this.effectId = new ResourceLocation(effectId);
        this.effectName = effectName != null ? new TranslatableComponent(effectName) : new TranslatableComponent("com." + this.effectId.m_135827_() + ".research." + this.effectId.m_135815_().replaceAll("[ /]", ".") + ".description");
        this.subtitle = new TranslatableComponent(subtitle);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public ResearchEffectCategory(String effectId, String effectName) {
        this.effectId = new ResourceLocation(effectId);
        this.effectName = new TranslatableComponent(effectName);
        this.subtitle = new TranslatableComponent("");
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public ResearchEffectCategory(String effectId) {
        this.effectId = new ResourceLocation(effectId);
        this.effectName = new TranslatableComponent("com." + this.effectId.m_135827_() + ".research." + this.effectId.m_135815_().replaceAll("[ /]", ".") + ".description");
        this.subtitle = new TranslatableComponent("");
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public void add(double newVal) {
        this.levelsRelative.add(newVal - this.levelsAbsolute.get(this.levelsAbsolute.size() - 1));
        this.levelsAbsolute.add(newVal);
    }

    public double getDisplay(int level) {
        return this.levelsRelative.get(level);
    }

    public double get(int level) {
        return this.levelsAbsolute.get(level);
    }

    public int getMaxLevel() {
        return this.levelsAbsolute.size() - 1;
    }

    public ResourceLocation getId() {
        return this.effectId;
    }

    public TranslatableComponent getName() {
        return this.effectName;
    }

    public TranslatableComponent getSubtitle() {
        return this.subtitle;
    }
}

