/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.WorldUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityDecorationController
extends BlockEntity
implements IBlueprintDataProvider {
    private static final String TAG_FACING = "facing";
    private String schematicName = "";
    private String schematicPath = "";
    private int tier = 0;
    private Direction basicFacing = Direction.NORTH;
    private BlockPos corner1 = BlockPos.f_121853_;
    private BlockPos corner2 = BlockPos.f_121853_;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();

    public TileEntityDecorationController(BlockPos pos, BlockState state) {
        super(MinecoloniesTileEntities.DECO_CONTROLLER, pos, state);
    }

    public String getSchematicPath() {
        return this.schematicPath;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String s) {
        this.schematicName = s;
    }

    public void setSchematicPath(String schematicPath) {
        this.schematicPath = schematicPath;
        if (this.f_58857_ != null) {
            this.update();
        }
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
        this.update();
    }

    public void setBasicFacing(Direction basicFacing) {
        this.basicFacing = basicFacing;
    }

    public Direction getBasicFacing() {
        return this.basicFacing;
    }

    private void update() {
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.m_6596_();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.f_121853_ || this.corner2 == BlockPos.f_121853_) {
            return new Tuple((Object)this.f_58858_, (Object)this.f_58858_);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    public void readSchematicDataFromNBT(CompoundTag compound) {
        super.readSchematicDataFromNBT(compound);
        if (compound.m_128441_("name")) {
            this.schematicPath = compound.m_128461_("name");
        }
        if (compound.m_128441_("level")) {
            this.tier = compound.m_128451_("level");
        }
        if (compound.m_128441_(TAG_FACING)) {
            this.basicFacing = Direction.m_122407_((int)compound.m_128451_(TAG_FACING));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        super.readSchematicDataFromNBT(compound);
        this.schematicPath = compound.m_128461_("name");
        this.tier = compound.m_128451_("level");
        this.basicFacing = Direction.m_122407_((int)compound.m_128451_(TAG_FACING));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSchematicDataToNBT(compound);
        compound.m_128359_("name", this.schematicPath);
        compound.m_128405_("level", this.tier);
        compound.m_128405_(TAG_FACING, this.basicFacing.m_122416_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    public BlockPos getTilePos() {
        return this.f_58858_;
    }
}

