/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.entity.ai.citizen.miner.MinerLevel;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.tileentities.TileEntityCompostedDirt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerUtil {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final String LEVEL_SIGN_TEXT = "{\"text\":\"level_placeholder\"}";
    private static final String LEVEL_SIGN_FIRST_ROW = "Text1";
    public static List<Tuple<ToolType, ItemStack>> tools;

    private WorkerUtil() {
    }

    public static List<Tuple<ToolType, ItemStack>> getOrInitTestTools() {
        if (tools == null) {
            tools = new ArrayList<Tuple<ToolType, ItemStack>>();
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.HOE, new ItemStack((ItemLike)Items.f_42424_)));
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.SHOVEL, new ItemStack((ItemLike)Items.f_42421_)));
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.AXE, new ItemStack((ItemLike)Items.f_42423_)));
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.PICKAXE, new ItemStack((ItemLike)Items.f_42422_)));
        }
        return tools;
    }

    public static boolean isPathBlock(Block block) {
        return block.m_49966_().m_204336_(ModTags.pathingBlocks);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site, int range) {
        return WorkerUtil.isWorkerAtSiteWithMove(worker, site.m_123341_(), site.m_123342_(), site.m_123343_(), range);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull AbstractEntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove((LivingEntity)worker, x, y, z, range)) {
            if (worker.getNavigation().m_26571_() && !EntityUtils.tryMoveLivingToXYZ((Mob)worker, x, y, z)) {
                worker.getCitizenStatusHandler().setStatus(Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull AbstractEntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.m_7678_((double)spawnPoint.m_123341_() + 0.5, spawnPoint.m_123342_(), (double)spawnPoint.m_123343_() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        citizen.getNavigation().m_26573_();
        return true;
    }

    public static IToolType getBestToolForBlock(BlockState state, float blockHardness) {
        String toolName = "";
        if (blockHardness > 0.0f) {
            for (Tuple<ToolType, ItemStack> tool : WorkerUtil.getOrInitTestTools()) {
                if (tool.getB() == null || !(tool.getB().m_41720_() instanceof DiggerItem) || !tool.getB().m_41735_(state)) continue;
                toolName = tool.getA().getName();
                break;
            }
        }
        IToolType toolType = ToolType.getToolType(toolName);
        return toolType;
    }

    public static int getCorrectHarvestLevelForBlock(BlockState target) {
        int required = 0;
        List tiers = TierSortingRegistry.getSortedTiers();
        for (Tier tier : tiers) {
            TagKey tag = tier.getTag();
            if (tag == null || !target.m_204336_(tag)) continue;
            required = tiers.indexOf(tier);
            break;
        }
        if (required < 0 && target.m_60767_() == Material.f_76320_ || target.m_60734_() instanceof GlazedTerracottaBlock) {
            return 0;
        }
        return required;
    }

    public static void faceBlock(@Nullable BlockPos block, AbstractEntityCitizen citizen) {
        if (block == null) {
            return;
        }
        double xDifference = block.m_123341_() - citizen.m_142538_().m_123341_();
        double zDifference = block.m_123343_() - citizen.m_142538_().m_123343_();
        double yDifference = (float)block.m_123342_() - ((float)citizen.m_142538_().m_123342_() + citizen.m_20192_());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.setOwnRotation((float)EntityUtils.updateRotation(citizen.getRotationYaw(), intendedRotationYaw, 30.0), (float)EntityUtils.updateRotation(citizen.getRotationPitch(), intendedRotationPitch, 30.0));
        double goToX = xDifference > 0.0 ? 0.001 : -0.001;
        double goToZ = zDifference > 0.0 ? 0.001 : -0.001;
        citizen.m_6478_(MoverType.SELF, new Vec3((double)((float)goToX), 0.0, (double)((float)goToZ)));
    }

    @Nullable
    public static BlockPos findFirstLevelSign(Blueprint structure, BlockPos pos) {
        for (int j = 0; j < structure.getSizeY(); ++j) {
            for (int k = 0; k < structure.getSizeZ(); ++k) {
                for (int i = 0; i < structure.getSizeX(); ++i) {
                    CompoundTag teData;
                    @NotNull BlockPos localPos = new BlockPos(i, j, k);
                    BlockInfo te = (BlockInfo)structure.getBlockInfoAsMap().get(localPos);
                    if (te == null || (teData = te.getTileEntityData()) == null || !teData.m_128461_(LEVEL_SIGN_FIRST_ROW).equals(LEVEL_SIGN_TEXT)) continue;
                    return pos.m_141950_((Vec3i)structure.getPrimaryBlockOffset()).m_141952_((Vec3i)localPos);
                }
            }
        }
        return null;
    }

    public static void updateLevelSign(Level world, MinerLevel level, int levelId) {
        BlockEntity te;
        @Nullable BlockPos levelSignPos = level.getLevelSign();
        if (levelSignPos != null && (te = world.m_7702_(levelSignPos)) instanceof SignBlockEntity) {
            BlockState BlockState2 = world.m_8055_(levelSignPos);
            SignBlockEntity teLevelSign = (SignBlockEntity)te;
            teLevelSign.m_59732_(0, (Component)new TextComponent(ChatFormatting.m_126649_((String)(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.minerminenode").getString() + ": " + levelId))));
            teLevelSign.m_59732_(1, (Component)new TextComponent(ChatFormatting.m_126649_((String)("Y: " + (level.getDepth() + 1)))));
            teLevelSign.m_59732_(2, (Component)new TextComponent(ChatFormatting.m_126649_((String)(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.minernode").getString() + ": " + level.getNumberOfBuiltNodes()))));
            teLevelSign.m_59732_(3, (Component)new TextComponent(ChatFormatting.m_126649_((String)"")));
            teLevelSign.m_6596_();
            world.m_7260_(levelSignPos, BlockState2, BlockState2, 3);
        }
    }

    public static boolean isThereCompostedLand(BuildingFlorist buildingFlorist, Level world) {
        for (BlockPos pos : buildingFlorist.getPlantGround()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (!((TileEntityCompostedDirt)entity).isComposted()) continue;
                return true;
            }
            buildingFlorist.removePlantableGround(pos);
        }
        return false;
    }

    public static int getLastLadder(@NotNull BlockPos pos, Level world) {
        if (world.m_8055_(pos).m_60734_().isLadder(world.m_8055_(pos), (LevelReader)world, pos, null)) {
            return WorkerUtil.getLastLadder(pos.m_7495_(), world);
        }
        return pos.m_123342_() + 1;
    }
}

