/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;

public class FTBLibraryCommands {
    public static final Map<UUID, CompoundTag> EDITING_NBT = new HashMap<UUID, CompoundTag>();

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection type) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftblibrary").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"gamemode").executes(context -> {
            if (!((CommandSourceStack)context.getSource()).m_81375_().m_7500_()) {
                ((CommandSourceStack)context.getSource()).m_81375_().m_143403_(GameType.CREATIVE);
            } else {
                ((CommandSourceStack)context.getSource()).m_81375_().m_143403_(GameType.SURVIVAL);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"rain").executes(context -> {
            ((CommandSourceStack)context.getSource()).m_81372_().m_8606_(1000000, 0, !((CommandSourceStack)context.getSource()).m_81372_().m_46471_(), false);
            return 1;
        }))).then(Commands.m_82127_((String)"day").executes(context -> {
            long addDay = (24000L - ((CommandSourceStack)context.getSource()).m_81372_().m_46468_() % 24000L + 6000L) % 24000L;
            if (addDay != 0L) {
                for (ServerLevel world : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
                    world.m_8615_(world.m_46468_() + addDay);
                }
            }
            return 1;
        }))).then(Commands.m_82127_((String)"night").executes(context -> {
            long addDay = (24000L - ((CommandSourceStack)context.getSource()).m_81372_().m_46468_() % 24000L + 18000L) % 24000L;
            if (addDay != 0L) {
                for (ServerLevel world : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
                    world.m_8615_(world.m_46468_() + addDay);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nbtedit").then(Commands.m_82127_((String)"block").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            Component title;
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)context, (String)"pos");
            BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
            if (blockEntity == null) {
                return;
            }
            info.m_128359_("type", "block");
            info.m_128405_("x", pos.m_123341_());
            info.m_128405_("y", pos.m_123342_());
            info.m_128405_("z", pos.m_123343_());
            tag.m_128391_(blockEntity.m_187480_());
            tag.m_128473_("x");
            tag.m_128473_("y");
            tag.m_128473_("z");
            info.m_128359_("id", tag.m_128461_("id"));
            tag.m_128473_("id");
            ListTag list = new ListTag();
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Class"), (Component)new TextComponent(blockEntity.getClass().getName()));
            ResourceLocation key = Registries.getId((Object)blockEntity.m_58903_(), (ResourceKey)Registry.f_122907_);
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("ID"), (Component)new TextComponent(key == null ? "null" : key.toString()));
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Block"), (Component)new TextComponent(String.valueOf(Registries.getId((Object)blockEntity.m_58900_().m_60734_(), (ResourceKey)Registry.f_122901_))));
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Block Class"), (Component)new TextComponent(blockEntity.m_58900_().m_60734_().getClass().getName()));
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Position"), (Component)new TextComponent("[" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + "]"));
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Mod"), (Component)new TextComponent(key == null ? "null" : Platform.getOptionalMod((String)key.m_135827_()).map(Mod::getName).orElse("Unknown")));
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Ticking"), (Component)new TextComponent(blockEntity instanceof TickingBlockEntity ? "true" : "false"));
            info.m_128365_("text", (Tag)list);
            Component component = title = blockEntity instanceof Nameable ? ((Nameable)blockEntity).m_5446_() : null;
            if (title == null) {
                title = new TextComponent(blockEntity.getClass().getSimpleName());
            }
            info.m_128359_("title", Component.Serializer.m_130703_((Component)title));
        }))))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
            if (entity instanceof Player) {
                return;
            }
            info.m_128359_("type", "entity");
            info.m_128405_("id", entity.m_142049_());
            entity.m_20223_(tag);
            ListTag list = new ListTag();
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Class"), (Component)new TextComponent(entity.getClass().getName()));
            ResourceLocation key = Registries.getId((Object)entity.m_6095_(), (ResourceKey)Registry.f_122903_);
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("ID"), (Component)new TextComponent(key == null ? "null" : key.toString()));
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Mod"), (Component)new TextComponent(key == null ? "null" : Platform.getOptionalMod((String)key.m_135827_()).map(Mod::getName).orElse("Unknown")));
            info.m_128365_("text", (Tag)list);
            info.m_128359_("title", Component.Serializer.m_130703_((Component)entity.m_5446_()));
        }))))).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            info.m_128359_("type", "player");
            info.m_128362_("id", player.m_142081_());
            player.m_20240_(tag);
            tag.m_128473_("id");
            ListTag list = new ListTag();
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Name"), player.m_7755_());
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("Display Name"), player.m_5446_());
            FTBLibraryCommands.addInfo(list, (Component)new TextComponent("UUID"), (Component)new TextComponent(player.m_142081_().toString()));
            info.m_128365_("text", (Tag)list);
            info.m_128359_("title", Component.Serializer.m_130703_((Component)player.m_5446_()));
        }))))).then(Commands.m_82127_((String)"item").executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            info.m_128359_("type", "item");
            player.m_21120_(InteractionHand.MAIN_HAND).m_41739_(tag);
        }))));
        if (Platform.isDevelopmentEnvironment()) {
            command.then(Commands.m_82127_((String)"test_screen").executes(context -> {
                FTBLibrary.PROXY.testScreen();
                return 1;
            }));
        }
        dispatcher.register(command);
    }

    private static void addInfo(ListTag list, Component key, Component value) {
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)key.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)value.m_6881_().m_130940_(ChatFormatting.GOLD)))));
    }

    private static int editNBT(CommandContext<CommandSourceStack> context, NBTEditCallback data) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CompoundTag info = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        data.accept(info, tag);
        if (!info.m_128456_()) {
            EDITING_NBT.put(player.m_142081_(), info);
            new EditNBTPacket(info, tag).sendTo(player);
            return 1;
        }
        return 0;
    }

    private static interface NBTEditCallback {
        public void accept(CompoundTag var1, CompoundTag var2) throws CommandSyntaxException;
    }
}

