/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked {
    public static final EnumProperty<EnumCompDrawer> SLOTS = EnumProperty.m_61587_((String)"slots", EnumCompDrawer.class);

    public BlockCompDrawers(int storageUnits, BlockBehaviour.Properties properties) {
        super(3, false, storageUnits, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SLOTS, (Comparable)((Object)EnumCompDrawer.OPEN1)));
    }

    public BlockCompDrawers(BlockBehaviour.Properties properties) {
        this(32, properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SLOTS});
    }

    @Override
    protected int getDrawerSlot(Direction side, Vec3 hit) {
        if (this.hitTop(hit.f_82480_)) {
            return 0;
        }
        if (this.hitLeft(side, hit.f_82479_, hit.f_82481_)) {
            return 1;
        }
        return 2;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        TileEntityDrawers tile = this.getTileEntity((BlockGetter)world, pos);
        if (tile != null) {
            IDrawerGroup group = tile.getGroup();
            for (int i = group.getDrawerCount() - 1; i >= 0; --i) {
                if (group.getDrawer(i).isEmpty()) continue;
                world.m_7731_(pos, (BlockState)state.m_61124_(SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(i + 1))), 3);
                break;
            }
        }
    }

    public TileEntityDrawers newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityDrawersComp.Slot3(pos, state);
    }
}

