/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;

public class TileEntityDrawersStandard
extends TileEntityDrawers {
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});
    private static final String[] GUI_IDS = new String[]{null, "storagedrawers:basicDrawers1", "storagedrawers:basicDrawers2", null, "storagedrawers:basicDrawers4"};
    private int capacity = 0;

    public TileEntityDrawersStandard(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    public static TileEntityDrawersStandard createEntity(int slotCount, BlockPos pos, BlockState state) {
        switch (slotCount) {
            case 1: {
                return new Slot1(pos, state);
            }
            case 2: {
                return new Slot2(pos, state);
            }
            case 4: {
                return new Slot4(pos, state);
            }
        }
        return null;
    }

    @Override
    public IDrawerGroup getGroup() {
        return null;
    }

    public static class Slot1
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(1);

        public Slot1(BlockPos pos, BlockState state) {
            super(ModBlocks.Tile.STANDARD_DRAWERS_1, pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super(ModBlocks.Tile.STANDARD_DRAWERS_2, pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot4
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(4);

        public Slot4(BlockPos pos, BlockState state) {
            super(ModBlocks.Tile.STANDARD_DRAWERS_4, pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            return TileEntityDrawersStandard.this.upgrades().getStorageMultiplier() * TileEntityDrawersStandard.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (TileEntityDrawersStandard.this.m_58904_() != null && !TileEntityDrawersStandard.this.m_58904_().f_46443_) {
                TileEntityDrawersStandard.this.m_6596_();
                TileEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (TileEntityDrawersStandard.this.m_58904_() != null && !TileEntityDrawersStandard.this.m_58904_().f_46443_) {
                TileEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                TileEntityDrawersStandard.this.m_6596_();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        private final LazyOptional<?> attributesHandler;

        public GroupData(int slotCount) {
            super(slotCount);
            this.attributesHandler = LazyOptional.of(TileEntityDrawersStandard.this::getDrawerAttributes);
        }

        @Override
        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean isGroupValid() {
            return TileEntityDrawersStandard.this.isGroupValid();
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.attributesHandler.cast();
            }
            return super.getCapability(capability, facing);
        }
    }
}

