/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ContainerDrawers
extends AbstractContainerMenu {
    private static final int InventoryX = 8;
    private static final int InventoryY = 117;
    private static final int HotbarY = 175;
    private static final int UpgradeX = 26;
    private static final int UpgradeY = 86;
    private Container upgradeInventory;
    private List<Slot> storageSlots;
    private List<Slot> upgradeSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;
    @OnlyIn(value=Dist.CLIENT)
    public StorageRenderItem activeRenderItem;
    private boolean isRemote;

    public ContainerDrawers(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(type, windowId, playerInv, ContainerDrawers.getTileEntity(playerInv, data.m_130135_()));
    }

    protected static TileEntityDrawers getTileEntity(Inventory playerInv, BlockPos pos) {
        Level world = playerInv.f_35978_.m_20193_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityDrawers) {
            return (TileEntityDrawers)tile;
        }
        StorageDrawers.log.error("Expected a drawers tile entity at " + pos.toString());
        return null;
    }

    public ContainerDrawers(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, TileEntityDrawers tileEntity) {
        super(type, windowId);
        int i;
        int drawerCount = 0;
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        Block block = tileEntity.m_58900_().m_60734_();
        IDrawerGroup group = tileEntity.getGroup();
        if (block instanceof BlockDrawers) {
            drawerCount = ((BlockDrawers)block).getDrawerCount();
        }
        this.storageSlots = new ArrayList<Slot>();
        for (i = 0; i < drawerCount; ++i) {
            if (!group.getDrawer(i).isEnabled()) continue;
            this.storageSlots.add(this.m_38897_(new SlotDrawer(this, group, i, this.getStorageSlotX(i), this.getStorageSlotY(i))));
        }
        this.upgradeSlots = new ArrayList<Slot>();
        for (i = 0; i < 7; ++i) {
            this.upgradeSlots.add(this.m_38897_(new SlotUpgrade(this.upgradeInventory, i, 26 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 175)));
        }
        this.isRemote = playerInventory.f_35978_.m_20193_().f_46443_;
    }

    public void setLastAccessedItem(ItemStack stack) {
        if (this.isRemote && this.activeRenderItem != null) {
            this.activeRenderItem.overrideStack = stack;
        }
    }

    protected int getStorageSlotX(int slot) {
        return 0;
    }

    protected int getStorageSlotY(int slot) {
        return 0;
    }

    public List<Slot> getStorageSlots() {
        return this.storageSlots;
    }

    public List<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public boolean m_6875_(Player player) {
        return this.upgradeInventory.m_6542_(player);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        int storageStart = this.storageSlots.get((int)0).f_40219_;
        int storageEnd = this.storageSlots.get((int)(this.storageSlots.size() - 1)).f_40219_ + 1;
        int upgradeStart = this.upgradeSlots.get((int)0).f_40219_;
        int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).f_40219_ + 1;
        int inventoryStart = this.playerSlots.get((int)0).f_40219_;
        int hotbarStart = this.hotbarSlots.get((int)0).f_40219_;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).f_40219_ + 1;
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack;
            block17: {
                slotStack = slot.m_7993_();
                itemStack = slotStack.m_41777_();
                if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                    if (!this.m_38903_(slotStack, inventoryStart, hotbarEnd, true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_40234_(slotStack, itemStack);
                } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && !slotStack.m_41619_()) {
                    if (slotStack.m_41720_() instanceof ItemUpgrade) {
                        ItemStack slotStack1 = slotStack.m_41777_();
                        slotStack1.m_41764_(1);
                        if (!this.m_38903_(slotStack1, upgradeStart, upgradeEnd, false)) {
                            if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.m_38903_(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.m_38903_(slotStack, inventoryStart, hotbarStart, false)) {
                                return ItemStack.f_41583_;
                            }
                            break block17;
                        } else {
                            slotStack.m_41774_(1);
                            if (slotStack.m_41613_() == 0) {
                                slot.m_5852_(ItemStack.f_41583_);
                            } else {
                                slot.m_6654_();
                            }
                            slot.m_142406_(player, slotStack);
                            return ItemStack.f_41583_;
                        }
                    }
                    if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.m_38903_(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.m_38903_(slotStack, inventoryStart, hotbarStart, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (!this.m_38903_(slotStack, inventoryStart, hotbarEnd, false)) {
                    return ItemStack.f_41583_;
                }
            }
            int slotStackSize = slotStack.m_41613_();
            if (slotStackSize == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStackSize == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }
}

