/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.IMenu;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class PopupMenu
implements IMenu {
    private int width;
    private int buttonHeight;
    private int x = 0;
    private int y = 0;
    protected List<AdvancedButton> content = new ArrayList<AdvancedButton>();
    private List<PopupMenu> children = new ArrayList<PopupMenu>();
    private PopupMenu parent;
    private boolean opened = false;
    private boolean hovered = false;
    private boolean autoclose = false;
    private int space;
    private boolean up = false;
    private boolean left = false;
    private int lastHeight = 0;

    public PopupMenu(int width, int buttonHeight, int space) {
        this.width = width;
        this.buttonHeight = buttonHeight;
        this.space = space;
    }

    public void render(int mouseX, int mouseY) {
        this.updateHovered(mouseX, mouseY);
        float ticks = Minecraft.func_71410_x().func_184121_ak();
        int stackedHeight = 0;
        if (this.opened) {
            for (AdvancedButton b : this.content) {
                b.setHandleClick(true);
                b.field_146120_f = this.width;
                b.field_146121_g = this.buttonHeight;
                if (this.parent != null) {
                    this.buttonHeight = this.parent.buttonHeight;
                    if (this.parent.left) {
                        this.left = true;
                        this.x = this.parent.x - this.parent.width - this.width - 2;
                    } else {
                        this.x = this.parent.x + this.parent.width + 2;
                    }
                    if (this.x + this.width > Minecraft.func_71410_x().field_71462_r.field_146294_l) {
                        this.x = this.parent.x - this.width - 2;
                        this.left = true;
                    } else if (!this.parent.left) {
                        this.left = false;
                    }
                    b.field_146128_h = this.x;
                    b.field_146129_i = this.up ? this.y + stackedHeight - this.lastHeight + this.buttonHeight + this.space : this.y + stackedHeight;
                } else {
                    b.field_146128_h = this.left ? this.x - this.width : this.x;
                    b.field_146129_i = this.up ? this.y + stackedHeight - this.lastHeight : this.y + stackedHeight;
                }
                b.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, ticks);
                stackedHeight += b.field_146121_g + this.space;
            }
            for (PopupMenu m : this.children) {
                m.render(mouseX, mouseY);
            }
        }
        if (this.autoclose && !this.isHovered() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
            this.opened = false;
        }
    }

    private void updateHovered(int mouseX, int mouseY) {
        for (AdvancedButton b : this.content) {
            if (mouseX < b.field_146128_h || mouseX > b.field_146128_h + b.field_146120_f || mouseY < b.field_146129_i || mouseY > b.field_146129_i + b.field_146121_g) continue;
            this.hovered = true;
            return;
        }
        this.hovered = false;
    }

    public boolean isLeftClicked() {
        for (AdvancedButton b : this.content) {
            if (!b.func_146115_a() || !MouseInput.isLeftMouseDown()) continue;
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        if (!this.isOpen()) {
            return false;
        }
        return this.hovered;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    public void setAutoclose(boolean b) {
        this.autoclose = b;
    }

    @Override
    public void setUseable(boolean b) {
        for (AdvancedButton bt : this.content) {
            bt.setUseable(b);
        }
        if (!b) {
            this.opened = false;
        }
    }

    @Override
    public boolean isUseable() {
        if (this.content == null || this.content.isEmpty()) {
            return false;
        }
        return this.content.get(0).isUseable();
    }

    public void openMenuAt(int x, int y) {
        for (PopupMenu m : this.children) {
            m.closeMenu();
        }
        this.x = x;
        this.y = y;
        this.lastHeight = 0;
        for (AdvancedButton b : this.content) {
            this.lastHeight += b.field_146121_g + this.space;
        }
        this.up = this.y + this.lastHeight > Minecraft.func_71410_x().field_71462_r.field_146295_m;
        this.left = this.x + this.width > Minecraft.func_71410_x().field_71462_r.field_146294_l;
        this.opened = true;
    }

    @Override
    public void closeMenu() {
        this.opened = false;
        for (PopupMenu m : this.children) {
            m.closeMenu();
        }
    }

    public void addContent(AdvancedButton button) {
        button.ignoreBlockedInput = true;
        this.content.add(button);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLastHeight() {
        return this.lastHeight;
    }

    public boolean isRenderedLeft() {
        return this.left;
    }

    public boolean isRenderedUp() {
        return this.up;
    }

    public void addChild(PopupMenu menu) {
        if (!this.children.contains(menu)) {
            this.children.add(menu);
            menu.parent = this;
        }
    }

    public void removeChild(PopupMenu menu) {
        if (this.children.contains(menu)) {
            this.children.remove(menu);
            menu.parent = null;
        }
    }
}

