/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content.scrollarea;

import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class ScrollArea
extends Gui {
    public Color backgroundColor = new Color(0, 0, 0, 240);
    public int x;
    public int y;
    public int width;
    public int height;
    public int grabberheight = 20;
    public int grabberwidth = 10;
    private List<ScrollAreaEntry> entries = new ArrayList<ScrollAreaEntry>();
    private boolean grabberHovered = false;
    private boolean grabberPressed = false;
    private int scrollpos = 0;
    private int entryheight = 0;
    private int startY = 0;
    private int startPos = 0;

    public ScrollArea(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        MouseInput.registerMouseListener(this::onMouseScroll);
    }

    public void render() {
        GlStateManager.func_179147_l();
        this.renderBackground();
        this.renderScrollbar();
        int i = 0;
        for (ScrollAreaEntry e : this.entries) {
            int scroll = this.scrollpos * (this.entryheight / (this.height - this.grabberheight));
            e.x = this.x;
            e.y = this.y + i - scroll;
            e.render();
            i += e.getHeight();
        }
    }

    protected void renderScrollbar() {
        if (this.height < this.entryheight) {
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            this.grabberHovered = this.x + this.width <= mouseX && this.x + this.width + this.grabberwidth >= mouseX && this.y + this.scrollpos <= mouseY && this.y + this.scrollpos + this.grabberheight >= mouseY;
            if (this.isGrabberHovered() && MouseInput.isLeftMouseDown()) {
                this.grabberPressed = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.grabberPressed = false;
            }
            if (!this.isGrabberHovered()) {
                ScrollArea.func_73734_a((int)(this.x + this.width), (int)(this.y + this.scrollpos), (int)(this.x + this.width + this.grabberwidth), (int)(this.y + this.scrollpos + this.grabberheight), (int)Color.GRAY.getRGB());
            } else {
                ScrollArea.func_73734_a((int)(this.x + this.width), (int)(this.y + this.scrollpos), (int)(this.x + this.width + this.grabberwidth), (int)(this.y + this.scrollpos + this.grabberheight), (int)Color.LIGHT_GRAY.getRGB());
            }
            if (this.isGrabberPressed()) {
                this.handleGrabberScrolling();
            } else {
                this.startY = MouseInput.getMouseY();
                this.startPos = this.scrollpos;
            }
        }
    }

    public boolean isAreaHovered() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return this.x <= mouseX && this.x + this.width + this.grabberwidth >= mouseX && this.y <= mouseY && this.y + this.height >= mouseY;
    }

    protected void handleGrabberScrolling() {
        int i = this.startY - MouseInput.getMouseY();
        int scroll = this.startPos - i;
        this.scrollpos = scroll < 0 ? 0 : (scroll > this.height - this.grabberheight ? this.height - this.grabberheight : scroll);
    }

    protected void renderBackground() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        ScrollArea.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backgroundColor.getRGB());
        GlStateManager.func_179121_F();
    }

    public void addEntry(ScrollAreaEntry e) {
        this.entries.add(e);
        this.scrollpos = 0;
        this.entryheight += e.getHeight();
    }

    public void removeEntry(ScrollAreaEntry e) {
        if (this.entries.contains((Object)e)) {
            this.entries.remove((Object)e);
            this.scrollpos = 0;
            this.entryheight -= e.getHeight();
        }
    }

    public List<ScrollAreaEntry> getEntries() {
        return this.entries;
    }

    public int getStackedEntryHeight() {
        return this.entryheight;
    }

    public boolean isGrabberHovered() {
        return this.grabberHovered;
    }

    public boolean isGrabberPressed() {
        return this.grabberPressed;
    }

    public void onMouseScroll(MouseInput.MouseData d) {
        if (this.isAreaHovered()) {
            int i = d.deltaZ / 120;
            int scroll = this.scrollpos - i * 7;
            this.scrollpos = scroll < 0 ? 0 : (scroll > this.height - this.grabberheight ? this.height - this.grabberheight : scroll);
        }
    }
}

