/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.rendering.animation;

import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ResourceUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.http.client.utils.URIBuilder;

public class AnimationRenderer
implements IAnimationRenderer {
    private String resourceDir;
    private int fps;
    private boolean loop;
    private int width;
    private int height;
    private int x;
    private int y;
    private List<ResourceLocation> resources = new ArrayList<ResourceLocation>();
    private boolean stretch = false;
    private boolean hide = false;
    private volatile boolean done = false;
    private String modid;
    private static FileSystem jarFileSystem = null;
    private int frame = 0;
    private long prevTime = 0L;

    public AnimationRenderer(String resourceDir, int fps, boolean loop, int posX, int posY, int width, int height, String modid) {
        this.fps = fps;
        this.loop = loop;
        this.x = posX;
        this.y = posY;
        this.width = width;
        this.height = height;
        this.resourceDir = resourceDir;
        this.modid = modid;
        this.loadAnimationFrames();
    }

    private void loadAnimationFrames() {
        try {
            List<String> resourcePaths = this.getAnimationResource(this.resourceDir, Minecraft.class);
            for (String s : resourcePaths) {
                String[] dir = ResourceUtils.splitToNamespaceAndPath(s, "/".charAt(0));
                this.resources.add(new ResourceLocation(dir[0], dir[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render() {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        if (this.fps < 0) {
            this.fps = -1;
        }
        if (this.frame > this.resources.size() - 1) {
            if (this.loop) {
                this.resetAnimation();
            } else {
                this.done = true;
                if (!this.hide) {
                    this.frame = this.resources.size() - 1;
                } else {
                    return;
                }
            }
        }
        this.renderFrame();
        long time = System.currentTimeMillis();
        if (this.fps == -1) {
            this.updateFrame(time);
        } else if (this.prevTime + (long)(1000 / this.fps) <= time) {
            this.updateFrame(time);
        }
    }

    private <T> List<String> getAnimationResource(String path, Class<T> c) throws URISyntaxException, IllegalArgumentException {
        ArrayList<String> ltemp = new ArrayList<String>();
        ArrayList<String> l = new ArrayList<String>();
        ArrayList<String> paths = new ArrayList<String>();
        try {
            Map mods = Loader.instance().getIndexedModList();
            if (!mods.containsKey(this.modid)) {
                throw new IllegalArgumentException("No mod found with modid: " + this.modid);
            }
            File f1 = ((ModContainer)mods.get(this.modid)).getSource();
            boolean isIDE = true;
            if (f1.getPath().endsWith(".jar")) {
                isIDE = false;
            }
            if (!isIDE) {
                if (jarFileSystem == null) {
                    URI uri = new URIBuilder(f1.toURI()).setScheme("jar:file").build();
                    jarFileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                Path path2 = jarFileSystem.getPath("/assets/" + path + "/", new String[0]);
                Stream<Path> pathStream = Files.walk(path2, 1, new FileVisitOption[0]);
                pathStream.forEach(p -> paths.add(p.getFileName().toString()));
                pathStream.close();
            } else {
                URL url = c.getResource("/assets/" + path + "/");
                if (url == null) {
                    throw new IllegalArgumentException("Resource URL cannot be null!");
                }
                File f2 = new File(url.toURI());
                if (f2 == null || !f2.exists()) {
                    throw new IllegalArgumentException("Resource path don't exists!");
                }
                paths.addAll(Arrays.asList(f2.list()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String s : paths) {
            String name;
            if (!s.contains(".") || !MathUtils.isInteger(name = new StringBuilder(new StringBuilder(s).reverse().toString().split("[.]", 2)[1]).reverse().toString())) continue;
            ltemp.add(s);
        }
        Collections.sort(ltemp, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int frame2;
                int frame1 = Integer.valueOf(new StringBuilder(new StringBuilder(o1).reverse().toString().split("[.]", 2)[1]).reverse().toString());
                if (frame1 > (frame2 = Integer.valueOf(new StringBuilder(new StringBuilder(o2).reverse().toString().split("[.]", 2)[1]).reverse().toString()).intValue())) {
                    return 1;
                }
                if (frame1 < frame2) {
                    return -1;
                }
                return 0;
            }
        });
        for (String s : ltemp) {
            l.add(path + "/" + s);
        }
        return l;
    }

    private void renderFrame() {
        int h = this.height;
        int w = this.width;
        int x2 = this.x;
        int y2 = this.y;
        if (this.stretch) {
            h = Minecraft.func_71410_x().field_71462_r.field_146295_m;
            w = Minecraft.func_71410_x().field_71462_r.field_146294_l;
            x2 = 0;
            y2 = 0;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resources.get(this.frame));
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiIngame.func_146110_a((int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)w, (float)h);
        GlStateManager.func_179084_k();
    }

    private void updateFrame(long time) {
        ++this.frame;
        this.prevTime = time;
    }

    @Override
    public void resetAnimation() {
        this.frame = 0;
        this.prevTime = 0L;
        this.done = false;
    }

    @Override
    public void setStretchImageToScreensize(boolean b) {
        this.stretch = b;
    }

    @Override
    public void setHideAfterLastFrame(boolean b) {
        this.hide = b;
    }

    @Override
    public boolean isFinished() {
        return this.done;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int currentFrame() {
        return this.frame;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setPosX(int x) {
        this.x = x;
    }

    @Override
    public void setPosY(int y) {
        this.y = y;
    }

    @Override
    public int animationFrames() {
        return this.resources.size();
    }

    @Override
    public String getPath() {
        return this.resourceDir;
    }

    @Override
    public void setFPS(int fps) {
        this.fps = fps;
    }

    @Override
    public int getFPS() {
        return this.fps;
    }

    @Override
    public void setLooped(boolean b) {
        this.loop = b;
    }

    @Override
    public void prepareAnimation() {
    }

    @Override
    public boolean isGettingLooped() {
        return this.loop;
    }

    @Override
    public boolean isStretchedToStreensize() {
        return this.stretch;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getPosX() {
        return this.x;
    }

    @Override
    public int getPosY() {
        return this.y;
    }
}

