/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.rendering.animation;

import com.google.common.io.Files;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExternalGifAnimationRenderer
implements IAnimationRenderer {
    private String resourceDir;
    private int fps = 0;
    private boolean loop;
    private int width;
    private int height;
    private int x;
    private int y;
    private List<ExternalTextureResourceLocation> resources = new ArrayList<ExternalTextureResourceLocation>();
    private List<Integer> delays = new ArrayList<Integer>();
    private boolean stretch = false;
    private boolean hide = false;
    private volatile boolean done = false;
    private volatile boolean ready = false;
    private int frame = 0;
    private long prevTime = 0L;

    public ExternalGifAnimationRenderer(String resourcePath, boolean loop, int posX, int posY, int width, int height) {
        this.loop = loop;
        this.x = posX;
        this.y = posY;
        this.width = width;
        this.height = height;
        this.resourceDir = resourcePath;
    }

    @Override
    public void prepareAnimation() {
        if (this.ready) {
            return;
        }
        try {
            File f = new File(this.resourceDir);
            if (f.exists() && f.isFile() && Files.getFileExtension((String)f.getName()).equalsIgnoreCase("gif")) {
                this.resources.clear();
                this.delays.clear();
                for (GifFramePackage g : ExternalGifAnimationRenderer.getGifFrames(this.resourceDir)) {
                    ExternalTextureResourceLocation er = new ExternalTextureResourceLocation(g.gif);
                    er.loadTexture();
                    if (!er.isReady()) continue;
                    this.resources.add(er);
                    this.delays.add(g.delay);
                }
                if (!this.resources.isEmpty()) {
                    if (this.width == 0) {
                        this.width = this.resources.get(0).getWidth();
                    }
                    if (this.height == 0) {
                        this.height = this.resources.get(0).getHeight();
                    }
                }
            } else {
                System.out.println("################ ERROR [FANCYMENU] ################");
                System.out.println("Unable to load GIF animation from " + this.resourceDir + "!");
                System.out.println("File not found or isn't a GIF!");
                System.out.println("###################################################");
            }
            this.ready = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render() {
        if (this.resources == null || this.resources.isEmpty()) {
            this.done = true;
            return;
        }
        if (!this.ready) {
            return;
        }
        if (this.frame > this.resources.size() - 1) {
            if (this.loop) {
                this.resetAnimation();
            } else {
                this.done = true;
                if (!this.hide) {
                    this.frame = this.resources.size() - 1;
                } else {
                    return;
                }
            }
        }
        this.renderFrame();
        long time = System.currentTimeMillis();
        if (this.fps == -1) {
            this.updateFrame(time);
        } else if (this.fps == 0) {
            if (this.prevTime + (long)(this.delays.get(this.frame) * 10) <= time) {
                this.updateFrame(time);
            }
        } else if (this.prevTime + (long)(1000 / this.fps) <= time) {
            this.updateFrame(time);
        }
    }

    private void renderFrame() {
        int h = this.height;
        int w = this.width;
        int x2 = this.x;
        int y2 = this.y;
        if (this.stretch) {
            h = Minecraft.func_71410_x().field_71462_r.field_146295_m;
            w = Minecraft.func_71410_x().field_71462_r.field_146294_l;
            x2 = 0;
            y2 = 0;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resources.get(this.frame).getResourceLocation());
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiIngame.func_146110_a((int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)w, (float)h);
        GlStateManager.func_179084_k();
    }

    private void updateFrame(long time) {
        ++this.frame;
        this.prevTime = time;
    }

    @Override
    public void resetAnimation() {
        this.frame = 0;
        this.prevTime = 0L;
        this.done = false;
    }

    @Override
    public void setStretchImageToScreensize(boolean b) {
        this.stretch = b;
    }

    @Override
    public void setHideAfterLastFrame(boolean b) {
        this.hide = b;
    }

    @Override
    public boolean isFinished() {
        return this.done;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int currentFrame() {
        return this.frame;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setPosX(int x) {
        this.x = x;
    }

    @Override
    public void setPosY(int y) {
        this.y = y;
    }

    @Override
    public int animationFrames() {
        return this.resources.size();
    }

    @Override
    public String getPath() {
        return this.resourceDir;
    }

    @Override
    public void setFPS(int fps) {
        this.fps = fps;
    }

    @Override
    public int getFPS() {
        return this.fps;
    }

    @Override
    public void setLooped(boolean b) {
        this.loop = b;
    }

    @Override
    public boolean isGettingLooped() {
        return this.loop;
    }

    @Override
    public boolean isStretchedToStreensize() {
        return this.stretch;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getPosX() {
        return this.x;
    }

    @Override
    public int getPosY() {
        return this.y;
    }

    private static List<GifFramePackage> getGifFrames(String gifPath) {
        File f = new File(gifPath);
        ArrayList<GifFramePackage> l = new ArrayList<GifFramePackage>();
        try {
            if (f.exists() && f.isFile() && Files.getFileExtension((String)f.getName()).equalsIgnoreCase("gif")) {
                String[] imageatt = new String[]{"imageLeftPosition", "imageTopPosition", "imageWidth", "imageHeight"};
                ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
                ImageInputStream ciis = ImageIO.createImageInputStream(f);
                reader.setInput(ciis, false);
                int noi = reader.getNumImages(true);
                BufferedImage master = null;
                for (int i = 0; i < noi; ++i) {
                    int delay = 0;
                    BufferedImage image = reader.read(i);
                    IIOMetadata metadata = reader.getImageMetadata(i);
                    Node tree = metadata.getAsTree("javax_imageio_gif_image_1.0");
                    NodeList children = tree.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        String d;
                        Node nodeItem = children.item(j);
                        if (nodeItem.getNodeName().equals("ImageDescriptor")) {
                            HashMap<String, Integer> imageAttr = new HashMap<String, Integer>();
                            for (int k = 0; k < imageatt.length; ++k) {
                                NamedNodeMap attr = nodeItem.getAttributes();
                                Node attnode = attr.getNamedItem(imageatt[k]);
                                imageAttr.put(imageatt[k], Integer.valueOf(attnode.getNodeValue()));
                            }
                            if (i == 0) {
                                master = new BufferedImage((Integer)imageAttr.get("imageWidth"), (Integer)imageAttr.get("imageHeight"), 2);
                            }
                            master.getGraphics().drawImage(image, (Integer)imageAttr.get("imageLeftPosition"), (Integer)imageAttr.get("imageTopPosition"), null);
                        }
                        if (!nodeItem.getNodeName().equals("GraphicControlExtension") || (d = ((IIOMetadataNode)nodeItem).getAttribute("delayTime")) == null || !MathUtils.isInteger(d)) continue;
                        delay = Integer.parseInt(d);
                    }
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write(master, "PNG", os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    l.add(new GifFramePackage(is, delay));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return l;
    }

    public static class GifFramePackage {
        ByteArrayInputStream gif;
        int delay;

        public GifFramePackage(ByteArrayInputStream gif, int delay) {
            this.gif = gif;
            this.delay = delay;
        }
    }
}

