/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.api.command;

import com.mojang.authlib.GameProfile;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.Random;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;

public abstract class TargetOfflineStorageCommand<T extends PokemonStorage>
extends CommandBase {
    public abstract T getStorageForUUID(UUID var1);

    public abstract StoragePosition getPositionFromArgs(ICommandSender var1, String[] var2) throws NumberFormatException;

    public abstract void execute(MinecraftServer var1, ICommandSender var2, String[] var3, T var4, Pokemon var5);

    public abstract int getMinimumArgs();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < this.getMinimumArgs()) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            return;
        }
        try {
            T storage;
            if (args[0].equalsIgnoreCase("@r")) {
                int size = sender.func_184102_h().func_184103_al().func_181057_v().size();
                Random r = new Random();
                int chance = r.nextInt(size);
                EntityPlayerMP player = TargetOfflineStorageCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)((EntityPlayerMP)sender.func_184102_h().func_184103_al().func_181057_v().get(chance)).func_70005_c_());
                storage = this.getStorageForUUID(player.func_110124_au());
            } else if (args[0].equalsIgnoreCase("@p")) {
                EntityPlayer playercheck = sender.func_130014_f_().func_184137_a((double)sender.func_180425_c().func_177958_n(), (double)sender.func_180425_c().func_177956_o(), (double)sender.func_180425_c().func_177952_p(), 100.0, false);
                if (playercheck == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
                    return;
                }
                EntityPlayerMP player = TargetOfflineStorageCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)playercheck.func_70005_c_());
                storage = this.getStorageForUUID(player.func_110124_au());
            } else if (PixelExtrasConfig.allowOfflineCheck) {
                GameProfile gp = server.func_152358_ax().func_152655_a(args[0]);
                if (gp == null || !TargetOfflineStorageCommand.hasPlayed(gp.getId())) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This player doesn't exist.", (Object[])new Object[0]);
                    return;
                }
                UUID uuid = gp.getId();
                storage = this.getStorageForUUID(uuid);
            } else {
                EntityPlayerMP player = TargetOfflineStorageCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                storage = this.getStorageForUUID(player.func_110124_au());
            }
            StoragePosition storagePosition = this.getPositionFromArgs(sender, args);
            Pokemon pokemon = storage.get(storagePosition);
            if (pokemon == null) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You have nothing in that slot!", (Object[])new Object[0]);
                return;
            }
            if (storage instanceof PartyStorage) {
                storage.retrieveAll();
            }
            this.execute(server, sender, args, storage, pokemon);
            return;
        }
        catch (PlayerNotFoundException e) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
            return;
        }
        catch (NumberFormatException e) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid number given!", (Object[])new Object[0]);
        }
    }

    public static boolean hasPlayed(UUID uuid) {
        PlayerPartyStorage partyStorage = new PlayerPartyStorage(uuid);
        return partyStorage.getFile().exists();
    }
}

