/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelextras.util.Cooldown;
import com.pixelextras.util.CooldownNotifier;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.BreedLogic;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Breed
extends CommandBase {
    public static Map<String, Cooldown> breedCooldowns = new ConcurrentHashMap<String, Cooldown>();
    private final PokemonSpec UNBREEDABLE = new PokemonSpec("unbreedable");

    public String func_71517_b() {
        return "breed";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/breed <party slot #1> <party slot #2>";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"pokebreed", "pbreed"});
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else {
            try {
                PixelmonReceivedEvent event;
                Pokemon egg;
                int slot2;
                PlayerPartyStorage pStorage;
                Cooldown cd;
                EntityPlayerMP player = Breed.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)sender.func_70005_c_());
                if (breedCooldowns.containsKey(player.func_110124_au().toString())) {
                    cd = breedCooldowns.get(player.func_110124_au().toString());
                    if (System.currentTimeMillis() - cd.getTimeUsed() < PixelExtrasConfig.breedCooldown) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("You may use this command again in " + (PixelExtrasConfig.breedCooldown - (System.currentTimeMillis() - cd.getTimeUsed())) / 1000L + " seconds."), (Object[])new Object[0]);
                        return;
                    }
                } else {
                    cd = new Cooldown(player.func_110124_au(), 0L);
                    breedCooldowns.put(player.func_110124_au().toString(), cd);
                }
                if ((pStorage = Pixelmon.storageManager.getParty(player)) == null) {
                    return;
                }
                int slot1 = Integer.parseInt(args[0].replaceAll("[^0-9]", "")) - 1;
                if (slot1 == (slot2 = Integer.parseInt(args[1].replaceAll("[^0-9]", "")) - 1)) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You cannot breed a Pokemon with itself!", (Object[])new Object[0]);
                    return;
                }
                Pokemon p1 = pStorage.get(slot1);
                Pokemon p2 = pStorage.get(slot2);
                if (p1 == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("Slot: " + slot1 + " is empty!"), (Object[])new Object[0]);
                    return;
                }
                if (p2 == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("Slot: " + slot2 + " is empty!"), (Object[])new Object[0]);
                    return;
                }
                if (this.UNBREEDABLE.matches(p1) && this.UNBREEDABLE.matches(p2)) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"%s and %s cannot be bred", (Object[])new Object[]{p1.getDisplayName(), p2.getDisplayName()});
                    return;
                }
                if (this.UNBREEDABLE.matches(p1)) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"pixelmon.ranch.cannotbreed", (Object[])new Object[]{p1.getDisplayName()});
                    return;
                }
                if (this.UNBREEDABLE.matches(p2)) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"pixelmon.ranch.cannotbreed", (Object[])new Object[]{p2.getDisplayName()});
                    return;
                }
                if (!p1.isEgg() && !p2.isEgg() && BreedLogic.canBreed((Pokemon)p1, (Pokemon)p2)) {
                    egg = BreedLogic.makeEgg((Pokemon)p1, (Pokemon)p2);
                    BreedEvent.MakeEgg makeEggEvent = new BreedEvent.MakeEgg(player.func_110124_au(), null, egg, p1, p2);
                    if (Pixelmon.EVENT_BUS.post((Event)makeEggEvent)) {
                        return;
                    }
                    egg = makeEggEvent.getEgg();
                    event = new PixelmonReceivedEvent(player, ReceiveType.Command, egg);
                    if (Pixelmon.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                } else {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"%s doesn't get along well with %s.", (Object[])new Object[]{p1.isEgg() ? "Egg" : p1.getDisplayName(), p2.isEgg() ? "Egg" : p2.getDisplayName()});
                    return;
                }
                egg = event.pokemon;
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)"%s and %s have bred and created an egg!", (Object[])new Object[]{p1.getDisplayName(), p2.getDisplayName()});
                pStorage.add(egg);
                if (cd.getNofifying()) {
                    CooldownNotifier.addNotifier(player.func_110124_au());
                } else {
                    CooldownNotifier.removeNotifier(player.func_110124_au());
                }
                cd.setTimeUsed(System.currentTimeMillis());
            }
            catch (PlayerNotFoundException e) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
            }
            catch (NumberFormatException e) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid number given!", (Object[])new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return Breed.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2 || args.length == 3) {
            return Breed.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

