/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.tickHandlers.WalkingEggHatcher;
import com.pixelmonmod.pixelmon.util.PixelmonPlayerUtils;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;

public class EggSteps
extends CommandBase {
    public String func_71517_b() {
        return "eggsteps";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/eggsteps [player] <slot>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int slot;
        EntityPlayerMP player;
        int argSlotIndex;
        if (args.length == 0) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Not enough arguments.", (Object[])new Object[0]);
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            return;
        }
        int n = argSlotIndex = args.length == 2 ? 1 : 0;
        if (args.length == 2) {
            player = PixelmonPlayerUtils.getUniquePlayerStartingWith((String)args[0]);
            if (player == null) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("No usernames starting with " + TextFormatting.BLUE + args[0] + "."), (Object[])new Object[0]);
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
                return;
            }
        } else if (sender instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)sender;
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"To use this command you must be a player or specify a player.", (Object[])new Object[0]);
            return;
        }
        try {
            slot = Integer.parseInt(args[argSlotIndex]);
            if (slot < 1 || slot > 6) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Slot number must be between 1 and 6.", (Object[])new Object[0]);
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            return;
        }
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
        Pokemon pokemon = storage.get(--slot);
        if (pokemon == null) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"There is not a Pok\u00e9mon in that slot.", (Object[])new Object[0]);
            return;
        }
        if (pokemon.isEgg()) {
            int steps = (pokemon.getEggCycles() + 1) * PixelmonConfig.stepsPerEggCycle - pokemon.getEggSteps();
            int bonus = new WalkingEggHatcher().getHatchBonus(storage);
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GRAY, (String)("Remaining steps: " + TextFormatting.YELLOW + steps / bonus), (Object[])new Object[0]);
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That isn't an egg.", (Object[])new Object[0]);
        }
    }
}

