/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class Evolve
extends CommandBase {
    public String func_71517_b() {
        return "pokeevolve";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pokeevolve <player> <slot> [-f]";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"evolve", "pevolve"});
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            CommandChatHandler.sendChat((ICommandSender)sender, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else if (args.length == 2 && args[1].equalsIgnoreCase("-f")) {
            this.func_184881_a(server, sender, new String[]{sender.func_70005_c_(), args[0], "-f"});
        } else if (args.length == 1) {
            this.func_184881_a(server, sender, new String[]{sender.func_70005_c_(), args[0]});
        } else {
            try {
                EntityPlayerMP player = Evolve.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                int slot = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
                if (slot < 1 || slot > 6) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Slot number must be between 1 and 6.", (Object[])new Object[0]);
                    return;
                }
                PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
                if (storage == null) {
                    return;
                }
                if (storage.get(slot - 1) != null) {
                    Pokemon p = storage.get(slot - 1);
                    ArrayList evo = p.getBaseStats().evolutions;
                    if (evo.size() <= 0) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"There are no more evolutions for this pixelmon!", (Object[])new Object[0]);
                        return;
                    }
                    if (p.isEgg()) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You cannot evolve an egg!", (Object[])new Object[0]);
                        return;
                    }
                    if (EnumSpecies.hasPokemonAnyCase((String)((Evolution)evo.get((int)0)).to.name)) {
                        EntityPixelmon entityPixelmon = p.getOrSpawnPixelmon((Entity)player);
                        boolean evolved = true;
                        boolean force = Arrays.stream(args).anyMatch(e -> e.equalsIgnoreCase("-f"));
                        for (Evolution evolution : evo) {
                            if (this.evoPassesAll(evolution.conditions, entityPixelmon, force)) {
                                evolution.doEvolution(entityPixelmon);
                                evolved = true;
                                break;
                            }
                            evolved = false;
                        }
                        if (!evolved) {
                            p.retrieve();
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That pokemon cannot evolve!", (Object[])new Object[0]);
                        }
                    }
                } else {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You have nothing in that slot!", (Object[])new Object[0]);
                }
            }
            catch (PlayerNotFoundException e2) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Player does not Exist!", (Object[])new Object[0]);
            }
        }
    }

    private boolean evoPassesAll(ArrayList<EvoCondition> evoConditions, EntityPixelmon entityPixelmon, boolean force) {
        if (force) {
            return true;
        }
        for (EvoCondition e : evoConditions) {
            if (e.passes(entityPixelmon)) continue;
            return false;
        }
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return Evolve.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return Evolve.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

