/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LearnMove
extends CommandBase {
    public String func_71517_b() {
        return "learnmove";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/learnmove <player> <slot> <move>";
    }

    public int func_82362_a() {
        return 2;
    }

    private boolean canLearnOtherMove(Pokemon p, String move) {
        LinkedHashSet otherMoves = p.getBaseStats().tutorMoves;
        otherMoves.addAll(p.getBaseStats().eggMoves);
        for (Attack a : otherMoves) {
            if (!a.getMove().getTranslatedName().equals((Object)move)) continue;
            return true;
        }
        return false;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else if (args.length == 2) {
            this.func_184881_a(server, sender, new String[]{sender.func_70005_c_(), args[0], args[1]});
        } else if (args.length == 3) {
            try {
                Optional a;
                EntityPlayerMP player = LearnMove.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                PlayerPartyStorage pStorage = Pixelmon.storageManager.getParty(player);
                if (pStorage == null) {
                    return;
                }
                int slot = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
                if (pStorage.guiOpened) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("You can't do this right now," + player.getDisplayNameString() + " has a menu open."), (Object[])new Object[0]);
                    return;
                }
                if (slot < 1 || slot > 6) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Slot number must be between 1 and 6.", (Object[])new Object[0]);
                    return;
                }
                Pokemon pokemon = pStorage.get(slot - 1);
                if (pokemon == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You have nothing in that slot!", (Object[])new Object[0]);
                    return;
                }
                Optional optional = a = !AttackBase.getAttackBase((String)args[2].replaceAll("_", " ")).isPresent() ? AttackBase.getAttackBase((int)Integer.parseInt(args[2].replaceAll("[^0-9]", ""))) : AttackBase.getAttackBase((String)args[2].replaceAll("_", " "));
                if (!a.isPresent()) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That move does not exist!", (Object[])new Object[0]);
                    return;
                }
                AttackBase attackBase = (AttackBase)a.get();
                pStorage.retrieveAll();
                if (pokemon.getBaseStats().canLearn(attackBase.getTranslatedName().func_150261_e()) || this.canLearnOtherMove(pokemon, attackBase.getTranslatedName().func_150261_e())) {
                    if (!pokemon.getMoveset().hasAttack(new String[]{attackBase.getTranslatedName().func_150261_e()})) {
                        if (pokemon.getMoveset().size() >= 4) {
                            Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(pokemon.getUUID(), attackBase), pokemon.getOwnerPlayer());
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)("Successfully sent the move to " + player.getDisplayNameString() + "'s " + pokemon.getDisplayName() + "."), (Object[])new Object[0]);
                        } else {
                            pokemon.getMoveset().add(new Attack(attackBase));
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)"pixelmon.stats.learnedmove", (Object[])new Object[]{pokemon.getDisplayName(), attackBase.getTranslatedName()});
                        }
                    } else {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)(pokemon.getDisplayName() + " has already learned this move!"), (Object[])new Object[0]);
                    }
                } else {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)(pokemon.getDisplayName() + " can not learn " + attackBase.getTranslatedName() + "!"), (Object[])new Object[0]);
                }
            }
            catch (PlayerNotFoundException e) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
            }
            catch (NumberFormatException e) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid number or move name given!", (Object[])new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return LearnMove.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return LearnMove.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        if (args.length == 3) {
            return LearnMove.func_175762_a((String[])args, (Collection)AttackBase.ATTACKS.stream().map(a -> a.getTranslatedName().func_150261_e().replaceAll(" ", "_")).collect(Collectors.toList()));
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

