/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.PixelmonPlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class Levelling
extends CommandBase {
    public String func_71517_b() {
        return "levelling";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"leveling"});
    }

    public String func_71518_a(ICommandSender sender) {
        return "/levelling [player] [slot] <on/off>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Missing arguments: on/off", (Object[])new Object[0]);
            return;
        }
        EntityPlayerMP player = null;
        int slot = -1;
        boolean levelling = false;
        for (String arg : args) {
            if (slot == -1) {
                try {
                    slot = Integer.parseInt(arg);
                    if (slot <= 6 && slot >= 1) continue;
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("Bad slot: " + slot), (Object[])new Object[0]);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (arg.toLowerCase().equals("on")) {
                levelling = true;
                continue;
            }
            if (arg.toLowerCase().equals("off")) {
                levelling = false;
                continue;
            }
            if (player != null) continue;
            player = PixelmonPlayerUtils.getUniquePlayerStartingWith((String)arg);
        }
        if (player == null) {
            if (sender instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)sender;
            } else {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"No player specified!", (Object[])new Object[0]);
                return;
            }
        }
        if (player != sender && sender instanceof EntityPlayerMP && !sender.func_70003_b(this.func_82362_a(), "pixelextras.command.admin.levelling")) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You don't have permission to use that on others!", (Object[])new Object[0]);
            return;
        }
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
        if (slot == -1) {
            for (Pokemon pokemon : storage.getTeam()) {
                if (pokemon == null || pokemon.isEgg()) continue;
                pokemon.setDoesLevel(levelling);
            }
            if (player != sender) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("Your Pokemon now have levelling " + (levelling ? "enabled.," : "disabled.")), (Object[])new Object[0]);
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully " + (levelling ? "enabled" : "disabled") + " " + TextFormatting.DARK_AQUA + player.func_70005_c_() + TextFormatting.DARK_GREEN + "'s party's levelling."), (Object[])new Object[0]);
            } else {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully " + (levelling ? "enabled" : "disabled") + " levelling."), (Object[])new Object[0]);
            }
        } else {
            Pokemon pokemon = storage.get(slot - 1);
            if (pokemon == null) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("There is no Pokemon in slot " + slot + "!"), (Object[])new Object[0]);
            } else if (pokemon.isEgg()) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That's an egg.", (Object[])new Object[0]);
            } else {
                String name = pokemon.getDisplayName();
                pokemon.setDoesLevel(levelling);
                if (player != sender) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)(name + " now has levelling " + (levelling ? "enabled.," : "disabled.")), (Object[])new Object[0]);
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully " + (levelling ? "enabled" : "disabled") + " " + TextFormatting.DARK_AQUA + player.func_70005_c_() + TextFormatting.DARK_GREEN + "'s " + name + "'s levelling."), (Object[])new Object[0]);
                } else {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully " + (levelling ? "enabled" : "disabled") + " " + name + "'s levelling."), (Object[])new Object[0]);
                }
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> tabCompletes = new ArrayList<String>(Levelling.func_71530_a((String[])args, (String[])server.func_71213_z()));
            tabCompletes.add("on");
            tabCompletes.add("off");
            tabCompletes.addAll(Arrays.asList("1", "2", "3", "4", "5", "6"));
            return tabCompletes;
        }
        if (args.length == 2) {
            return Levelling.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6", "on", "off"});
        }
        if (args.length == 3) {
            return Levelling.func_71530_a((String[])args, (String[])new String[]{"on", "off"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

