/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PokeClone
extends CommandBase {
    public String func_71517_b() {
        return "pokeclone";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("pclone");
    }

    public String func_71518_a(ICommandSender sender) {
        return "&c/pokeclone <slot> [player]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 1 && sender == server) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You must specify a player if you are using this command from console.", (Object[])new Object[0]);
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else if (args.length > 0) {
            try {
                int slot = Integer.parseInt(args[0]);
                if (slot < 1 || slot > 6) {
                    throw new NumberFormatException();
                }
                EntityPlayerMP player = args.length == 2 ? server.func_184103_al().func_152612_a(args[1]) : (EntityPlayerMP)sender;
                if (player == null) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("No player found with username: " + args[1]), (Object[])new Object[0]);
                } else {
                    PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
                    Pokemon pokemon = storage.get(--slot);
                    if (pokemon == null) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("No pokemon in slot " + (slot + 1) + "."), (Object[])new Object[0]);
                    } else {
                        NBTTagCompound nbt = new NBTTagCompound();
                        pokemon.writeToNBT(nbt);
                        Pokemon clone = Pixelmon.pokemonFactory.create(nbt);
                        clone.setUUID(UUID.randomUUID());
                        EnumSpecies name = clone.getSpecies();
                        PixelmonReceivedEvent event = new PixelmonReceivedEvent(player, ReceiveType.Command, clone);
                        if (Pixelmon.EVENT_BUS.post((Event)event)) {
                            return;
                        }
                        storage.add(clone);
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully cloned " + name.name + "."), (Object[])new Object[0]);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)(args[0] + " is not a valid slot"), (Object[])new Object[0]);
            }
        }
    }
}

