/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.pixelextras.api.command.TargetOfflineStorageCommand;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class PokeDel
extends CommandBase {
    public String func_71517_b() {
        return "pokedel";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/pokedel <name> <pc | party> <pokemon [options...] | slot>";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("pdel");
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        block42: {
            if (args.length < 3) {
                CommandChatHandler.sendChat((ICommandSender)sender, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            } else {
                try {
                    PCStorage pcStorage;
                    PlayerPartyStorage pStorage;
                    ArrayList players = Lists.newArrayList((Object[])server.func_71213_z());
                    if (players.contains(args[0])) {
                        EntityPlayerMP player = PokeDel.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                        pStorage = Pixelmon.storageManager.getParty(player);
                        pcStorage = Pixelmon.storageManager.getPCForPlayer(player);
                    } else {
                        GameProfile gp = server.func_152358_ax().func_152655_a(args[0]);
                        if (gp == null || !TargetOfflineStorageCommand.hasPlayed(gp.getId())) {
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This player doesn't exist.", (Object[])new Object[0]);
                            return;
                        }
                        UUID uuid = gp.getId();
                        pStorage = Pixelmon.storageManager.getParty(uuid);
                        pcStorage = Pixelmon.storageManager.getPCForPlayer(uuid);
                    }
                    Boolean checkingParty = null;
                    if (args[1].toLowerCase().equals("pc")) {
                        checkingParty = false;
                    } else if (args[1].toLowerCase().equals("party")) {
                        checkingParty = true;
                    }
                    if (checkingParty == null) {
                        CommandChatHandler.sendChat((ICommandSender)sender, (String)this.func_71518_a(sender), (Object[])new Object[0]);
                        return;
                    }
                    int slot = -1;
                    int box = -1;
                    ArrayList tempargs = Lists.newArrayList((Object[])args);
                    tempargs.remove(0);
                    tempargs.remove(0);
                    PokemonSpec spec = new PokemonSpec(String.join((CharSequence)" ", tempargs));
                    boolean emptySpec = false;
                    try {
                        NBTTagCompound nbt = new NBTTagCompound();
                        emptySpec = spec.matches(nbt);
                    }
                    catch (Exception nbt) {
                        // empty catch block
                    }
                    if (emptySpec) {
                        try {
                            box = Integer.parseInt(args[2]) - 1;
                            slot = Integer.parseInt(args[3]) - 1;
                        }
                        catch (Exception nbt) {
                            // empty catch block
                        }
                        if (checkingParty.booleanValue()) {
                            if (box < 0 || box > 5) {
                                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid slot or Pokemon spec!", (Object[])new Object[0]);
                                return;
                            }
                        } else if (box < 0 || box >= PixelmonConfig.computerBoxes || slot < 0 || slot > 5) {
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid slot or Pokemon spec!", (Object[])new Object[0]);
                            return;
                        }
                    }
                    boolean confirmed = false;
                    for (String arg : args) {
                        if (!arg.toLowerCase().equals("confirm")) continue;
                        confirmed = true;
                    }
                    pStorage.retrieveAll();
                    if (emptySpec) {
                        String name;
                        if (checkingParty.booleanValue()) {
                            Pokemon pokemon = pStorage.get(box);
                            if (pokemon == null) {
                                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"No Pokemon in that slot.", (Object[])new Object[0]);
                                return;
                            }
                            if (pStorage.countAll() == 1) {
                                name = pokemon.getDisplayName();
                                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)(args[0] + "'s " + name + " is the last Pokemon of their team, you can't delete it!"), (Object[])new Object[0]);
                                return;
                            }
                            name = pokemon.getDisplayName();
                            pStorage.set(box, null);
                        } else {
                            Pokemon pokemon = pcStorage.getBox(box).get(slot);
                            if (pokemon == null) {
                                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"No Pokemon in that slot.", (Object[])new Object[0]);
                                return;
                            }
                            name = pokemon.getDisplayName();
                            pcStorage.set(box, slot, null);
                        }
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Deleted " + args[0] + "'s " + name + "."), (Object[])new Object[0]);
                        break block42;
                    }
                    ArrayList<Pokemon> nbts = new ArrayList<Pokemon>();
                    if (checkingParty.booleanValue()) {
                        slot = 0;
                        for (Pokemon pokemon : pStorage.getTeam()) {
                            if (pokemon != null && spec.matches(pokemon)) {
                                if (confirmed) {
                                    pStorage.set(slot, null);
                                }
                                nbts.add(pokemon);
                            }
                            ++slot;
                        }
                    } else {
                        for (box = 0; box < PixelmonConfig.computerBoxes; ++box) {
                            for (slot = 0; slot < 30; ++slot) {
                                Pokemon pokemon = pcStorage.getBox(box).get(slot);
                                if (pokemon == null || !spec.matches(pokemon)) continue;
                                if (confirmed) {
                                    pcStorage.set(box, slot, null);
                                }
                                nbts.add(pokemon);
                            }
                        }
                    }
                    if (nbts.isEmpty()) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"No matches found.", (Object[])new Object[0]);
                        return;
                    }
                    if (confirmed) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully deleted " + nbts.size() + " Pokemon."), (Object[])new Object[0]);
                    } else {
                        StringBuilder list = new StringBuilder(((Pokemon)nbts.get(0)).getDisplayName());
                        for (int i = 1; i < nbts.size(); ++i) {
                            list.append(", ").append(((Pokemon)nbts.get(i)).getDisplayName());
                        }
                        if (spec.name == null) {
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("Warning - The following " + nbts.size() + " Pokemon will be deleted: " + list), (Object[])new Object[0]);
                        } else {
                            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("Warning - " + nbts.size() + " Pokemon will be deleted."), (Object[])new Object[0]);
                        }
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)"Run this command again with \"confirm\" to delete these Pokemon.", (Object[])new Object[0]);
                    }
                }
                catch (PlayerNotFoundException e) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
                }
                catch (Exception e) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"There was an error! Report this to Hiroku!", (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            return PokeDel.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            for (int i = 1; i < 17; ++i) {
                list.add("box" + i);
            }
            list.add("party");
            return PokeDel.func_175762_a((String[])args, list);
        }
        if (args.length == 3) {
            for (EnumSpecies p : EnumSpecies.values()) {
                list.add(p.name);
            }
            return PokeDel.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

